/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.deployed;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.deployed.ProcessedTemplate;
import com.xebialabs.deployit.plugin.generic.step.TemplateArtifactCopyStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;

@Metadata(virtual=true, description="Base type for all Tomcat resources")
public class ContextElement<D extends Deployable>
extends ProcessedTemplate<D> {
    @Property(required=false, description="The name of the context that this resource is associated with")
    private String context;
    private boolean destroyOperation;
    private boolean createOperation;

    public void executeCreate(DeploymentPlanningContext ctx) {
        this.createOperation = true;
        super.executeCreate(ctx);
    }

    public void executeModify(DeploymentPlanningContext ctx, Delta d) {
        ContextElement previous = (ContextElement)d.getPrevious();
        previous.executeDestroy(ctx);
        this.executeCreate(ctx);
    }

    public void executeDestroy(DeploymentPlanningContext ctx) {
        this.destroyOperation = true;
        TemplateArtifactCopyStep step = this.createTemplateArtifactCopyStep();
        step.setDescription(this.getDescription(this.getDestroyVerb()));
        ctx.addStep((DeploymentStep)step);
    }

    public String getDescription(String verb) {
        return String.format("%s %s in %s.xml on %s", verb, this.getName(), this.getContext(), ((HostContainer)this.getContainer()).getName());
    }

    public String getContext() {
        return this.resolveExpression(this.context);
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean isDestroyOperation() {
        return this.destroyOperation;
    }

    public void setDestroyOperation(boolean destroyOperation) {
        this.destroyOperation = destroyOperation;
    }

    public boolean isCreateOperation() {
        return this.createOperation;
    }

    public void setCreateOperation(boolean createOperation) {
        this.createOperation = createOperation;
    }
}

