/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.deployed;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.deployed.CopiedArtifact;
import com.xebialabs.deployit.plugin.generic.step.ArtifactDeleteStep;
import com.xebialabs.deployit.plugin.generic.step.TemplateArtifactCopyStep;
import com.xebialabs.deployit.plugin.jee.artifact.War;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.tomcat.step.RenameFileStep;
import java.util.Set;

@Metadata(virtual=true, description="War Module that has an associated context.xml")
public class ContextWarModule
extends CopiedArtifact<War> {
    @Property(description="Context root under which the web application can be access", defaultValue="${deployed.name}")
    private String contextRoot;
    @Property(hidden=true, description="Freemarker template used to create the context xml for the War")
    private String contextTemplate;
    @Property(hidden=true, description="Target directory to which the context xml must to copied to on the target system")
    private String contextXmlTargetDirectory;
    @Property(hidden=true, defaultValue="60", description="The order of the create context step in the step list for the create operation.")
    private int createOrderOfContextXml;
    @Property(hidden=true, defaultValue="60", description="The order of the rename context root step in the step list for the modify operation.")
    private int modifyOrderOfContextXml;
    @Property(hidden=true, defaultValue="40", description="The order of the destroy context step in the step list for the create operation.")
    private int destroyOrderOfContextXml;
    @Property(hidden=true, defaultValue="war settings")
    private String contextSubject;
    @Property(required=false, hidden=true, description="Absolute paths to files on the target system that was generated and must be clean up during a destroy operation")
    private Set<String> deleteGeneratedResources = Sets.newHashSet();
    private boolean destroyOperation;

    public void executeModify(DeploymentPlanningContext ctx, Delta d) {
        ContextWarModule old = (ContextWarModule)d.getPrevious();
        if (!old.getContextRoot().equals(this.getContextRoot())) {
            String fileSeparator = ((HostContainer)this.getContainer()).getHost().getOs().getFileSeparator();
            String source = old.resolveContextFile(fileSeparator);
            String target = this.resolveContextFile(fileSeparator);
            String description = "Change context from " + old.getContextRoot() + " to " + this.getContextRoot() + " on " + ((HostContainer)this.getContainer()).getName();
            ctx.addStep((DeploymentStep)new RenameFileStep(this.getModifyOrderOfContextXml(), source, target, description, (HostContainer)this.getContainer()));
        }
        ctx.addStep((DeploymentStep)old.createArtifactDeleteStep());
        ctx.addStep((DeploymentStep)this.createTemplateArtifactCopyStep(this.getModifyOrderOfContextXml(), this.getModifyVerb()));
        ctx.addStep((DeploymentStep)this.createArtifactCopyStep());
    }

    public void executeCreate(DeploymentPlanningContext ctx) {
        ctx.addStep((DeploymentStep)this.createTemplateArtifactCopyStep(this.getCreateOrderOfContextXml(), this.getCreateVerb()));
        ctx.addStep((DeploymentStep)this.createArtifactCopyStep());
    }

    public void executeDestroy(DeploymentPlanningContext ctx) {
        this.destroyOperation = true;
        ctx.addStep((DeploymentStep)this.createTemplateArtifactCopyStep(this.getDestroyOrderOfContextXml(), this.getModifyVerb()));
        ctx.addStep((DeploymentStep)this.createArtifactDeleteStep());
    }

    protected TemplateArtifactCopyStep createTemplateArtifactCopyStep(int order, String verb) {
        TemplateArtifactCopyStep step = new TemplateArtifactCopyStep(order, (HostContainer)this.getContainer(), this.getDeployedAsFreeMarkerContext(), this.getContextTemplate(), this.getContextXmlTargetDirectory());
        step.setCreateTargetPath(this.isCreateTargetDirectory());
        step.setTargetFileName(this.getContextRoot() + ".xml");
        step.setSourceFileDescription("Context Xml");
        step.setDescription(this.getContextDescription(verb));
        return step;
    }

    protected ArtifactDeleteStep createArtifactDeleteStep() {
        ArtifactDeleteStep step = super.createArtifactDeleteStep();
        step.setDeleteAdditionalTargetFiles((Set)Sets.newHashSet((Object[])new String[]{this.getTargetDirectory() + step.getHostFileSeparator() + this.getContextRoot()}));
        return step;
    }

    public String resolveContextFile(String fileSeparator) {
        return this.getContextXmlTargetDirectory() + fileSeparator + this.getContextRoot() + ".xml";
    }

    public String getContextDescription(String verb) {
        return String.format("%s %s in %s.xml on %s", verb, this.getContextSubject(), this.getContextRoot(), ((HostContainer)this.getContainer()).getName());
    }

    public String getContextRoot() {
        return this.resolveExpression(this.contextRoot);
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public String getContextTemplate() {
        return this.resolveExpression(this.contextTemplate);
    }

    public void setContextTemplate(String contextTemplate) {
        this.contextTemplate = contextTemplate;
    }

    public int getCreateOrderOfContextXml() {
        return this.createOrderOfContextXml;
    }

    public void setCreateOrderOfContextXml(int createOrderOfContextXml) {
        this.createOrderOfContextXml = createOrderOfContextXml;
    }

    public String getContextXmlTargetDirectory() {
        return this.resolveExpression(this.contextXmlTargetDirectory);
    }

    public void setContextXmlTargetDirectory(String contextXmlTargetDirectory) {
        this.contextXmlTargetDirectory = contextXmlTargetDirectory;
    }

    public Set<String> getDeleteGeneratedResources() {
        return this.resolveExpression(this.deleteGeneratedResources);
    }

    public void setDeleteGeneratedResources(Set<String> deleteGeneratedResources) {
        this.deleteGeneratedResources = deleteGeneratedResources;
    }

    public int getModifyOrderOfContextXml() {
        return this.modifyOrderOfContextXml;
    }

    public void setModifyOrderOfContextXml(int modifyOrderOfContextXml) {
        this.modifyOrderOfContextXml = modifyOrderOfContextXml;
    }

    public int getDestroyOrderOfContextXml() {
        return this.destroyOrderOfContextXml;
    }

    public void setDestroyOrderOfContextXml(int destroyOrderOfContextXml) {
        this.destroyOrderOfContextXml = destroyOrderOfContextXml;
    }

    public boolean isDestroyOperation() {
        return this.destroyOperation;
    }

    public String getContextSubject() {
        return this.contextSubject;
    }

    public void setContextSubject(String contextSubject) {
        this.contextSubject = contextSubject;
    }
}

