/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.processor;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.tomcat.deployed.ContextElement;
import com.xebialabs.deployit.plugin.tomcat.deployed.ContextWarModule;
import com.xebialabs.deployit.plugin.tomcat.processor.Utils;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationContextNameInjector {
    public static final Type APPLICATION_CONTEXT_TYPE = Type.valueOf((String)"tomcat.VirtualHost");
    private static final Logger logger = LoggerFactory.getLogger(ApplicationContextNameInjector.class);

    @PrePlanProcessor
    public List<DeploymentStep> injectContextNameInToContextElements(DeltaSpecification spec) {
        Iterable<ContextElement<?>> contextElements = this.findAllContextElementsTargetedToApplicationContexts(spec.getDeltas());
        logger.debug("Found {} context elements targeted to application contexts", (Object)Iterables.size(contextElements));
        Iterable<Delta> warModules = ApplicationContextNameInjector.findContextWarModulesTargetedToVirtualHost(spec.getDeltas());
        logger.debug("Found {} warModules targeted to application contexts", (Object)Iterables.size(warModules));
        this.injectContextNameIntoContextElementsUsingWarResolution(warModules, contextElements);
        this.validateAllContextElementsTargetedToApplicationContextHasCtxNameSet(contextElements);
        return Collections.emptyList();
    }

    protected void injectContextNameIntoContextElementsUsingWarResolution(Iterable<Delta> warModules, Iterable<ContextElement<?>> contextElements) {
        if (Iterables.size(warModules) == 1) {
            Delta warModuleDelta = warModules.iterator().next();
            this.injectContextIntoContextElementsUsingWar(warModuleDelta, contextElements);
        }
    }

    protected void validateAllContextElementsTargetedToApplicationContextHasCtxNameSet(Iterable<ContextElement<?>> contextElements) {
        for (ContextElement<?> ce : contextElements) {
            Preconditions.checkState((Strings.emptyToNull((String)ce.getContext()) != null ? 1 : 0) != 0, (String)"Context for resource %s targeted to %s cannot be determined. Please specify the context.", (Object[])new Object[]{ce.getName(), ((HostContainer)ce.getContainer()).getName()});
        }
    }

    protected void injectContextIntoContextElementsUsingWar(Delta warModuleDelta, Iterable<ContextElement<?>> contextElements) {
        block3: {
            ContextWarModule warModule;
            block2: {
                warModule = (ContextWarModule)warModuleDelta.getDeployed();
                logger.debug("Only a single war targeted to application context. All contextElements without a context will be associated with '{}'", (Object)warModule.getContextRoot());
                if (warModuleDelta.getOperation() != Operation.CREATE) break block2;
                for (ContextElement<?> contextElement : contextElements) {
                    if (Strings.emptyToNull((String)contextElement.getContext()) != null) continue;
                    contextElement.setContext(warModule.getContextRoot());
                }
                break block3;
            }
            if (warModuleDelta.getPrevious() == null) break block3;
            ContextWarModule oldWarModule = (ContextWarModule)warModuleDelta.getPrevious();
            for (ContextElement<?> contextElement : contextElements) {
                if (!oldWarModule.getContextRoot().equals(contextElement.getContext()) && Strings.emptyToNull((String)contextElement.getContext()) != null) continue;
                contextElement.setContext(warModule.getContextRoot());
            }
        }
    }

    protected Iterable<ContextElement<?>> findAllContextElementsTargetedToApplicationContexts(List<Delta> deltas) {
        Iterable<AbstractDeployed<?>> deployeds = Utils.findDeployedsTargetedToContainer(deltas, APPLICATION_CONTEXT_TYPE);
        return Utils.extractDeployedContextElements(deployeds);
    }

    protected static Iterable<Delta> findContextWarModulesTargetedToVirtualHost(List<Delta> deltas) {
        return Iterables.filter(deltas, (Predicate)new Predicate<Delta>(){

            public boolean apply(Delta input) {
                if (input.getOperation() != Operation.DESTROY) {
                    return this.accept(input.getDeployed());
                }
                return false;
            }

            private boolean accept(Deployed<?, ?> deployed) {
                return deployed != null && Utils.isSubtypeOf(APPLICATION_CONTEXT_TYPE, deployed.getContainer().getType()) && deployed instanceof ContextWarModule;
            }
        });
    }
}

