package com.xebialabs.deployit.plugin.tomcat.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.deployed.ProcessedTemplate;
import com.xebialabs.deployit.plugin.generic.step.TemplateArtifactCopyStep;

@Metadata(virtual = true, description = "Base type for all Tomcat resources")
public class ContextElement<D extends Deployable> extends ProcessedTemplate<D> {

    @Property(required = false, description = "The name of the context that this resource is associated with")
    private String context;

    private boolean destroyOperation;
    private boolean createOperation;

    @Override
    public void executeCreate(DeploymentPlanningContext ctx) {
        createOperation = true;
        super.executeCreate(ctx);
    }

    @Override
    public void executeModify(DeploymentPlanningContext ctx, Delta d) {
        ContextElement<D> previous = (ContextElement<D>) d.getPrevious();
		previous.executeDestroy(ctx);
		executeCreate(ctx);
    }

    @Override
    public void executeDestroy(DeploymentPlanningContext ctx) {
        destroyOperation = true;
        TemplateArtifactCopyStep step = createTemplateArtifactCopyStep();
        step.setDescription(getDescription(getDestroyVerb()));
        ctx.addStep(step);
    }

    @Override
    public String getDescription(String verb) {
        return String.format("%s %s in %s.xml on %s", verb, getName(), getContext(), getContainer().getName());
    }

    public String getContext() {
        return resolveExpression(context);
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean isDestroyOperation() {
        return destroyOperation;
    }

    public void setDestroyOperation(boolean destroyOperation) {
        this.destroyOperation = destroyOperation;
    }

    public boolean isCreateOperation() {
        return createOperation;
    }

    public void setCreateOperation(boolean createOperation) {
        this.createOperation = createOperation;
    }
}
