/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.freemarker;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.generic.step.BaseDeploymentStep;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.dom.NodeModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ContextXmlHelper {
    private BaseDeploymentStep step;

    public ContextXmlHelper(BaseDeploymentStep baseDeploymentStep) {
        this.step = baseDeploymentStep;
    }

    public NodeModel readOrCreateContext(String string) {
        if (!this.step.hostFileExists(string)) {
            this.step.createOrReplaceHostFile("<Context></Context>", string);
        }
        return this.step.readHostXmlFileAsModel(string);
    }

    public String attributeMapToString(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey()).append("=\"").append(entry.getValue()).append("\" ");
        }
        return stringBuilder.toString();
    }

    public Map<String, String> resolveElementAttributes(NodeModel nodeModel, BeanModel beanModel, Map<String, String> map, boolean bl) throws TemplateModelException {
        HashMap hashMap = Maps.newHashMap();
        if (bl) {
            List<String> list = this.resolveAttributeNamesFromPropertyToAttributeMapping(map);
            hashMap.putAll(this.removeAttributes(nodeModel, list));
        } else {
            Map<String, String> map2 = this.populateElementAttributesFromCi(beanModel, map);
            hashMap.putAll(this.mergeWithElementAttributes(nodeModel, map2));
        }
        return hashMap;
    }

    public Map<String, String> populateElementAttributesFromCi(BeanModel beanModel, Map<String, String> map) throws TemplateModelException {
        HashMap hashMap = Maps.newHashMap();
        BeansWrapper beansWrapper = BeansWrapper.getDefaultInstance();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = Strings.emptyToNull((String)entry.getValue()) == null ? string : entry.getValue();
            TemplateModel templateModel = beanModel.get(string);
            Object object = beansWrapper.unwrap(templateModel);
            if (object instanceof Map) {
                object = this.convertMapToTomcatMapStringFormat((Map)object);
            }
            if (object == null) continue;
            hashMap.put(string2, object.toString());
        }
        return hashMap;
    }

    protected List<String> resolveAttributeNamesFromPropertyToAttributeMapping(Map<String, String> map) {
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = Strings.emptyToNull((String)entry.getValue()) == null ? string : entry.getValue();
            arrayList.add(string2);
        }
        return arrayList;
    }

    protected String convertMapToTomcatMapStringFormat(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue()).append(';');
        }
        return stringBuilder.toString();
    }

    protected Map<String, String> mergeWithElementAttributes(NodeModel nodeModel, Map<String, String> map) throws TemplateModelException {
        Node node = nodeModel.getNode();
        HashMap hashMap = Maps.newHashMap();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap == null ? 0 : namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = namedNodeMap.item(i);
            hashMap.put(node2.getNodeName(), node2.getNodeValue());
        }
        hashMap.putAll(map);
        return hashMap;
    }

    protected Map<String, String> removeAttributes(NodeModel nodeModel, Collection<String> collection) throws TemplateModelException {
        Node node = nodeModel.getNode();
        HashMap hashMap = Maps.newHashMap();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap == null ? 0 : namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = namedNodeMap.item(i);
            if (collection.contains(node2.getNodeName())) continue;
            hashMap.put(node2.getNodeName(), node2.getNodeValue());
        }
        return hashMap;
    }
}

