/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.contributor;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.generic.step.ArtifactDeleteStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.tomcat.deployed.ContextElement;
import com.xebialabs.deployit.plugin.tomcat.deployed.ContextWarModule;
import java.util.List;

public class ContextXmlCleanup {
    @Contributor
    public void cleanupContextXml(Deltas deltas, DeploymentPlanningContext result) {
        Iterable<Delta> deltasTargetedToVirtualHosts = this.findDeltasTargetedToVirtualHosts(deltas);
        ListMultimap<String, Delta> deltasPerWebApp = this.groupByWebContext(deltasTargetedToVirtualHosts);
        for (String context : deltasPerWebApp.keySet()) {
            List webAppDeltas = deltasPerWebApp.get((Object)context);
            boolean undeploymentInProgress = this.undeploymentInProgress(webAppDeltas);
            Optional<Delta> optional = this.findWarModule(webAppDeltas);
            if (!optional.isPresent()) continue;
            Delta warDelta = (Delta)optional.get();
            ContextWarModule warModule = (ContextWarModule)this.getDeployed(warDelta);
            if (undeploymentInProgress) {
                if (!warModule.isManageContextXml()) continue;
                result.addStep((Step)this.createDeleteStep((HostContainer)warModule.getContainer(), warModule.getDestroyOrderOfContextXml() + 1, warModule.getContextXmlTargetDirectory(), context));
                continue;
            }
            if (warDelta.getOperation() != Operation.DESTROY) continue;
            throw new RuntimeException("There are still resources referencing war. War can only be undeployed when associated resources are also undeployed.");
        }
    }

    private Optional<Delta> findWarModule(List<Delta> webAppDeltas) {
        return Iterables.tryFind(webAppDeltas, (Predicate)new Predicate<Delta>(){

            public boolean apply(Delta input) {
                Deployed deployed = ContextXmlCleanup.this.getDeployed(input);
                return deployed instanceof ContextWarModule;
            }
        });
    }

    private boolean undeploymentInProgress(List<Delta> webAppDeltas) {
        return Iterables.all(webAppDeltas, (Predicate)new Predicate<Delta>(){

            public boolean apply(Delta input) {
                return input.getOperation() == Operation.DESTROY;
            }
        });
    }

    private Deployed<?, ?> getDeployed(Delta delta) {
        return delta.getOperation() == Operation.DESTROY ? delta.getPrevious() : delta.getDeployed();
    }

    private Iterable<Delta> findDeltasTargetedToVirtualHosts(Deltas deltas) {
        final Type APPLICATION_CONTEXT_TYPE = Type.valueOf((String)"tomcat.VirtualHost");
        return FluentIterable.from((Iterable)deltas.getDeltas()).filter((Predicate)new Predicate<Delta>(){

            public boolean apply(Delta input) {
                Deployed deployed = ContextXmlCleanup.this.getDeployed(input);
                if (deployed.getContainer().getType().getDescriptor().isAssignableTo(APPLICATION_CONTEXT_TYPE)) {
                    return deployed instanceof ContextElement || deployed instanceof ContextWarModule;
                }
                return false;
            }
        });
    }

    private ListMultimap<String, Delta> groupByWebContext(Iterable<Delta> deltas) {
        return Multimaps.index(deltas, (Function)new Function<Delta, String>(){

            public String apply(Delta input) {
                Deployed deployed = ContextXmlCleanup.this.getDeployed(input);
                String context = deployed instanceof ContextElement ? ((ContextElement)deployed).getContext() : ((ContextWarModule)deployed).getContextRoot();
                return context;
            }
        });
    }

    private ArtifactDeleteStep createDeleteStep(HostContainer container, int order, String targetDirectory, String context) {
        ArtifactDeleteStep step = new ArtifactDeleteStep(order, container, targetDirectory);
        step.setTargetFile(context + ".xml");
        step.setDescription("Removing " + context + " xml from " + targetDirectory);
        return step;
    }
}

