/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.vsphere.access;

import com.google.common.base.Joiner;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.mo.ComputeResource;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import com.xebialabs.deployit.plugin.cloud.vsphere.access.VsphereUtils;
import com.xebialabs.deployit.plugin.cloud.vsphere.ci.Credentials;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;

public class VsphereAdapter
implements Serializable {
    private transient ServiceInstance si;
    private Credentials credentials;

    public VsphereAdapter(Credentials credentials) {
        this.credentials = credentials;
    }

    public void logout() {
        if (this.si != null) {
            this.si.getServerConnection().logout();
        }
    }

    public ServiceInstance getSi() {
        if (this.si == null) {
            try {
                this.si = new ServiceInstance(new URL(this.credentials.getUrl()), this.credentials.getUsername(), this.credentials.getPassword(), this.credentials.isIgnoreCert());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
            catch (RemoteException e) {
                throw new VsphereAdapterException(e.getMessage());
            }
        }
        return this.si;
    }

    public Datacenter getDatacenter(String name) {
        try {
            return (Datacenter)this.getSi().getSearchIndex().findByInventoryPath(name);
        }
        catch (RemoteException e) {
            throw new VsphereAdapterException("Can not find datacenter by name " + name + " : " + e.getMessage());
        }
    }

    public VirtualMachine getVm(String datacenter, String path) {
        String p = VsphereUtils.vmPath(datacenter, path);
        return this.getVm(p);
    }

    public VirtualMachine getVm(String path) {
        try {
            return (VirtualMachine)this.getSi().getSearchIndex().findByInventoryPath(path);
        }
        catch (RemoteException e) {
            throw new VsphereAdapterException("Can not get template " + path + " : " + e.getMessage());
        }
    }

    public ComputeResource getHost(String datacenter, String path) {
        String p = VsphereUtils.hostPath(datacenter, path);
        try {
            return (ComputeResource)this.getSi().getSearchIndex().findByInventoryPath(p);
        }
        catch (RemoteException e) {
            throw new VsphereAdapterException("Can not get host " + path + " at datacenter " + datacenter + " : " + e.getMessage());
        }
    }

    public Folder getVmFolder(String datacenter, String path) {
        String p = VsphereUtils.vmPath(datacenter, path);
        try {
            ManagedEntity target = this.getSi().getSearchIndex().findByInventoryPath(p);
            Folder folder = target instanceof Datacenter ? ((Datacenter)target).getVmFolder() : (Folder)target;
            List<String> allowedTypes = Arrays.asList(folder.getChildType());
            if (!allowedTypes.contains("VirtualMachine")) {
                throw new IllegalArgumentException(path + " child types do not allow VirtualMachine type. Allowed types: " + Joiner.on((String)", ").join(allowedTypes));
            }
            return folder;
        }
        catch (RemoteException e) {
            throw new VsphereAdapterException("Can not get folder " + path + " at datacenter " + datacenter + " : " + e.getMessage());
        }
    }

    public Task getTask(String morId) {
        ManagedObjectReference mor = new ManagedObjectReference();
        mor.setType("Task");
        mor.setVal(morId);
        return new Task(this.getSi().getServerConnection(), mor);
    }

    public String getIpAddress(String path) {
        return (String)this.getVm(path).getPropertyByPath("guest.ipAddress");
    }

    public static class VsphereAdapterException
    extends RuntimeException {
        public VsphereAdapterException(String message) {
            super(message);
        }
    }
}

