/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.rest;

public class ResultConverter {
    static final String TABLE_START = "<table";
    static final String TABLE_END = "</table";
    static final String TR_START = "<tr>";
    static final String TD_START = "<td";
    static final String TD_END = "</td>";
    static final String LINK_END = "</a>";

    public static String convert2Xml(String html) {
        StringBuffer xml = new StringBuffer("<xml> <result");
        int pos = html.indexOf("<");
        String resultType = html.substring(1, pos);
        xml.append(" type=\"" + resultType + "\">\n");
        int tableEnd = html.lastIndexOf(TABLE_END);
        ResultConverter.convertTable(html, pos, tableEnd, xml);
        xml.append("</result> </xml>");
        return xml.toString();
    }

    private static int convertTable(String html, int from, int to, StringBuffer xml) {
        int pos = html.indexOf(TABLE_START, from);
        pos = html.indexOf(TR_START, pos) + TR_START.length();
        while ((pos = html.indexOf(TR_START, pos)) != -1) {
            if (pos > to) {
                return to;
            }
            pos = html.indexOf(TD_START, pos);
            int nameStart = html.indexOf(">", pos) + 1;
            int nameEnd = html.indexOf(TD_END, nameStart);
            String name = html.substring(nameStart, nameEnd);
            pos = html.indexOf(TD_START, nameEnd);
            int typeStart = html.indexOf(">", pos) + 1;
            int typeEnd = html.indexOf(TD_END, typeStart);
            String type = html.substring(typeStart, typeEnd);
            xml.append("<" + name + " type=\"" + type + "\">");
            pos = ResultConverter.convertTdValue(html, typeEnd, to, type, xml);
            xml.append("</" + name + ">\n");
        }
        return pos;
    }

    private static int convertTdValue(String html, int from, int to, String type, StringBuffer xml) {
        int pos = html.indexOf(TD_START, from);
        String value = "";
        if (!ResultConverter.isSimpleTdValue(html, pos, to)) {
            int tableEnd = ResultConverter.getTableEnd(html, pos + TD_START.length() + TABLE_START.length(), to - 1);
            pos = ResultConverter.convertTable(html, pos, tableEnd + TABLE_END.length() + 1, xml);
        } else {
            int valueEnd;
            int valueStart = html.indexOf(">", pos) + 1;
            value = html.substring(valueStart, valueEnd = html.indexOf(TD_END, valueStart));
            if ("Unset".equals(value)) {
                value = "";
            } else if ("string".equals(type)) {
                value = value.substring(1, value.length() - 1);
            } else if (value.indexOf("href=") != -1) {
                int start = value.indexOf(">");
                int end = value.indexOf(LINK_END, start);
                value = value.substring(start + 1, end);
            }
            xml.append(value);
        }
        return pos;
    }

    private static boolean isSimpleTdValue(String html, int from, int to) {
        int pos = html.indexOf("</", from);
        return html.startsWith(TD_END, pos) || html.startsWith(LINK_END, pos);
    }

    private static int getTableEnd(String html, int from, int to) {
        int tagLevel = 0;
        int pos = from;
        do {
            if (html.charAt((pos = html.indexOf("<", pos + 1)) + 1) == '/') {
                if (!html.startsWith(TABLE_END, pos)) continue;
                --tagLevel;
                continue;
            }
            if (!html.startsWith(TABLE_START, pos)) continue;
            ++tagLevel;
        } while (tagLevel != 0);
        return pos;
    }
}

