/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.DasConfigFault;
import com.vmware.vim25.HostCapability;
import com.vmware.vim25.HostConfigFault;
import com.vmware.vim25.HostConfigInfo;
import com.vmware.vim25.HostConfigManager;
import com.vmware.vim25.HostConnectFault;
import com.vmware.vim25.HostConnectInfo;
import com.vmware.vim25.HostConnectSpec;
import com.vmware.vim25.HostFlagInfo;
import com.vmware.vim25.HostHardwareInfo;
import com.vmware.vim25.HostIpmiInfo;
import com.vmware.vim25.HostLicensableResourceInfo;
import com.vmware.vim25.HostListSummary;
import com.vmware.vim25.HostPowerOpFailed;
import com.vmware.vim25.HostRuntimeInfo;
import com.vmware.vim25.HostServiceTicket;
import com.vmware.vim25.HostSystemReconnectSpec;
import com.vmware.vim25.HostSystemResourceInfo;
import com.vmware.vim25.HostSystemSwapConfiguration;
import com.vmware.vim25.HostTpmAttestationReport;
import com.vmware.vim25.InvalidIpmiLoginInfo;
import com.vmware.vim25.InvalidIpmiMacAddress;
import com.vmware.vim25.InvalidLogin;
import com.vmware.vim25.InvalidName;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotSupported;
import com.vmware.vim25.RequestCanceled;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.Timedout;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.HostAutoStartManager;
import com.vmware.vim25.mo.HostBootDeviceSystem;
import com.vmware.vim25.mo.HostCacheConfigurationManager;
import com.vmware.vim25.mo.HostCpuSchedulerSystem;
import com.vmware.vim25.mo.HostDatastoreBrowser;
import com.vmware.vim25.mo.HostDatastoreSystem;
import com.vmware.vim25.mo.HostDateTimeSystem;
import com.vmware.vim25.mo.HostDiagnosticSystem;
import com.vmware.vim25.mo.HostEsxAgentHostManager;
import com.vmware.vim25.mo.HostFirewallSystem;
import com.vmware.vim25.mo.HostFirmwareSystem;
import com.vmware.vim25.mo.HostHealthStatusSystem;
import com.vmware.vim25.mo.HostImageConfigManager;
import com.vmware.vim25.mo.HostKernelModuleSystem;
import com.vmware.vim25.mo.HostMemorySystem;
import com.vmware.vim25.mo.HostNetworkSystem;
import com.vmware.vim25.mo.HostPatchManager;
import com.vmware.vim25.mo.HostPciPassthruSystem;
import com.vmware.vim25.mo.HostServiceSystem;
import com.vmware.vim25.mo.HostSnmpSystem;
import com.vmware.vim25.mo.HostStorageSystem;
import com.vmware.vim25.mo.HostVMotionSystem;
import com.vmware.vim25.mo.HostVirtualNicManager;
import com.vmware.vim25.mo.IscsiManager;
import com.vmware.vim25.mo.LicenseManager;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.Network;
import com.vmware.vim25.mo.OptionManager;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.util.MorUtil;
import java.rmi.RemoteException;

public class HostSystem
extends ManagedEntity {
    private HostConfigManager configManager = null;

    public HostSystem(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public HostCapability getCapability() {
        return (HostCapability)this.getCurrentProperty("capability");
    }

    public HostConfigInfo getConfig() {
        return (HostConfigInfo)this.getCurrentProperty("config");
    }

    public Datastore[] getDatastores() throws InvalidProperty, RuntimeFault, RemoteException {
        return this.getDatastores("datastore");
    }

    public HostDatastoreBrowser getDatastoreBrowser() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostDatastoreBrowser)this.getManagedObject("datastoreBrowser");
    }

    public HostHardwareInfo getHardware() {
        return (HostHardwareInfo)this.getCurrentProperty("hardware");
    }

    public HostLicensableResourceInfo getLicensableResource() {
        return (HostLicensableResourceInfo)this.getCurrentProperty("licensableResource");
    }

    public Network[] getNetworks() throws InvalidProperty, RuntimeFault, RemoteException {
        return this.getNetworks("network");
    }

    public HostRuntimeInfo getRuntime() {
        return (HostRuntimeInfo)this.getCurrentProperty("runtime");
    }

    public HostListSummary getSummary() {
        return (HostListSummary)this.getCurrentProperty("summary");
    }

    public HostSystemResourceInfo getSystemResources() {
        return (HostSystemResourceInfo)this.getCurrentProperty("systemResources");
    }

    public VirtualMachine[] getVms() throws InvalidProperty, RuntimeFault, RemoteException {
        return this.getVms("vm");
    }

    public HostServiceTicket acquireCimServicesTicket() throws RuntimeFault, RemoteException {
        return this.getVimService().acquireCimServicesTicket(this.getMOR());
    }

    public Task disconnectHost() throws RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().disconnectHost_Task(this.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public void enterLockdownMode() throws HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().enterLockdownMode(this.getMOR());
    }

    public Task enterMaintenanceMode(int timeout, boolean evacuatePoweredOffVms) throws Timedout, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().enterMaintenanceMode_Task(this.getMOR(), timeout, new Boolean(evacuatePoweredOffVms));
        return new Task(this.getServerConnection(), mor);
    }

    public void exitLockdownMode() throws HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().exitLockdownMode(this.getMOR());
    }

    public Task exitMaintenanceMode(int timeout) throws Timedout, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().exitMaintenanceMode_Task(this.getMOR(), timeout);
        return new Task(this.getServerConnection(), mor);
    }

    public Task powerDownHostToStandBy(int timeSec, boolean evacuatePoweredOffVms) throws RequestCanceled, HostPowerOpFailed, NotSupported, Timedout, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().powerDownHostToStandBy_Task(this.getMOR(), timeSec, new Boolean(evacuatePoweredOffVms));
        return new Task(this.getServerConnection(), mor);
    }

    public Task powerUpHostFromStandBy(int timeSec) throws HostPowerOpFailed, NotSupported, Timedout, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().powerUpHostFromStandBy_Task(this.getMOR(), timeSec);
        return new Task(this.getServerConnection(), mor);
    }

    public HostConnectInfo queryHostConnectionInfo() throws RuntimeFault, RemoteException {
        return this.getVimService().queryHostConnectionInfo(this.getMOR());
    }

    public HostTpmAttestationReport queryTpmAttestationReport() throws RuntimeFault, RemoteException {
        return this.getVimService().queryTpmAttestationReport(this.getMOR());
    }

    public void updateSystemSwapConfiguration(HostSystemSwapConfiguration sysSwapConfig) throws RuntimeFault, RemoteException {
        this.getVimService().updateSystemSwapConfiguration(this.getMOR(), sysSwapConfig);
    }

    public long queryMemoryOverhead(long memorySize, int videoRamSize, int numVcpus) throws RuntimeFault, RemoteException {
        return this.getVimService().queryMemoryOverhead(this.getMOR(), memorySize, new Integer(videoRamSize), numVcpus);
    }

    public long queryMemoryOverheadEx(VirtualMachineConfigInfo vmConfigInfo) throws RuntimeFault, RemoteException {
        return this.getVimService().queryMemoryOverheadEx(this.getMOR(), vmConfigInfo);
    }

    public Task rebootHost(boolean force) throws InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().rebootHost_Task(this.getMOR(), force);
        return new Task(this.getServerConnection(), mor);
    }

    public Task reconfigureHostForDAS() throws DasConfigFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().reconfigureHostForDAS_Task(this.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public Task reconnectHost_Task(HostConnectSpec hcs) throws InvalidName, InvalidLogin, InvalidState, HostConnectFault, RuntimeFault, RemoteException {
        return this.reconnectHost_Task(hcs, null);
    }

    public Task reconnectHost_Task(HostConnectSpec cnxSpec, HostSystemReconnectSpec reconnectSpec) throws InvalidName, InvalidLogin, InvalidState, HostConnectFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().reconnectHost_Task(this.getMOR(), cnxSpec, reconnectSpec);
        return new Task(this.getServerConnection(), mor);
    }

    public long retrieveHardwareUptime() throws RuntimeFault, RemoteException {
        return this.getVimService().retrieveHardwareUptime(this.getMOR());
    }

    public Task shutdownHost_Task(boolean force) throws InvalidState, NotSupported, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().shutdownHost_Task(this.getMOR(), force);
        return new Task(this.getServerConnection(), mor);
    }

    public void updateFlags(HostFlagInfo hfi) throws RuntimeFault, RemoteException {
        this.getVimService().updateFlags(this.getMOR(), hfi);
    }

    public void updateSystemResources(HostSystemResourceInfo resourceInfo) throws RuntimeFault, RemoteException {
        this.getVimService().updateSystemResources(this.getMOR(), resourceInfo);
    }

    public void updateIpmi(HostIpmiInfo ipmiInfo) throws InvalidIpmiLoginInfo, InvalidIpmiMacAddress, RuntimeFault, RemoteException {
        this.getVimService().updateIpmi(this.getMOR(), ipmiInfo);
    }

    private HostConfigManager getConfigManager() throws InvalidProperty, RuntimeFault, RemoteException {
        if (this.configManager == null) {
            this.configManager = (HostConfigManager)this.getCurrentProperty("configManager");
        }
        return this.configManager;
    }

    public OptionManager getOptionManager() throws InvalidProperty, RuntimeFault, RemoteException {
        return new OptionManager(this.getServerConnection(), this.getConfigManager().getAdvancedOption());
    }

    public HostAutoStartManager getHostAutoStartManager() throws InvalidProperty, RuntimeFault, RemoteException {
        return new HostAutoStartManager(this.getServerConnection(), this.getConfigManager().getAutoStartManager());
    }

    public HostBootDeviceSystem getHostBootDeviceSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostBootDeviceSystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getBootDeviceSystem());
    }

    public HostDateTimeSystem getHostDateTimeSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostDateTimeSystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getDateTimeSystem());
    }

    public HostDiagnosticSystem getHostDiagnosticSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostDiagnosticSystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getDiagnosticSystem());
    }

    public HostEsxAgentHostManager getHostEsxAgentHostManager() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostEsxAgentHostManager)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getEsxAgentHostManager());
    }

    public HostCacheConfigurationManager getHostCacheConfigurationManager() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostCacheConfigurationManager)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getCacheConfigurationManager());
    }

    public HostCpuSchedulerSystem getHostCpuSchedulerSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostCpuSchedulerSystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getCpuScheduler());
    }

    public HostDatastoreSystem getHostDatastoreSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostDatastoreSystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getDatastoreSystem());
    }

    public HostFirmwareSystem getHostFirmwareSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostFirmwareSystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getFirmwareSystem());
    }

    public HostKernelModuleSystem getHostKernelModuleSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostKernelModuleSystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getKernelModuleSystem());
    }

    public LicenseManager getLicenseManager() throws InvalidProperty, RuntimeFault, RemoteException {
        return (LicenseManager)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getLicenseManager());
    }

    public HostPciPassthruSystem getHostPciPassthruSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostPciPassthruSystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getPciPassthruSystem());
    }

    public HostVirtualNicManager getHostVirtualNicManager() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostVirtualNicManager)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getVirtualNicManager());
    }

    public HostHealthStatusSystem getHealthStatusSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostHealthStatusSystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getHealthStatusSystem());
    }

    public HostFirewallSystem getHostFirewallSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostFirewallSystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getFirewallSystem());
    }

    public HostImageConfigManager getHostImageConfigManager() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostImageConfigManager)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getImageConfigManager());
    }

    public HostMemorySystem getHostMemorySystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostMemorySystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getMemoryManager());
    }

    public HostNetworkSystem getHostNetworkSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostNetworkSystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getNetworkSystem());
    }

    public HostPatchManager getHostPatchManager() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostPatchManager)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getPatchManager());
    }

    public HostServiceSystem getHostServiceSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostServiceSystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getServiceSystem());
    }

    public HostSnmpSystem getHostSnmpSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostSnmpSystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getSnmpSystem());
    }

    public HostStorageSystem getHostStorageSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostStorageSystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getStorageSystem());
    }

    public IscsiManager getIscsiManager() throws InvalidProperty, RuntimeFault, RemoteException {
        return (IscsiManager)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getIscsiManager());
    }

    public HostVMotionSystem getHostVMotionSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        return (HostVMotionSystem)MorUtil.createExactManagedObject(this.getServerConnection(), this.getConfigManager().getVmotionSystem());
    }
}

