/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.vsphere.steps;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.VirtualMachineCloneSpec;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualMachineRelocateSpec;
import com.vmware.vim25.mo.ComputeResource;
import com.vmware.vim25.mo.CustomizationSpecManager;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.cloud.step.ContextAttribute;
import com.xebialabs.deployit.plugin.cloud.util.ContextHelper;
import com.xebialabs.deployit.plugin.cloud.vsphere.access.VsphereAdapter;
import com.xebialabs.deployit.plugin.cloud.vsphere.access.VsphereUtils;
import com.xebialabs.deployit.plugin.cloud.vsphere.ci.HostTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class CreateVSphereInstanceStep
implements Step {
    private HostTemplate template;
    private String instanceName;
    private VsphereAdapter adapter;

    public CreateVSphereInstanceStep(HostTemplate template, String name, VsphereAdapter adapter) {
        this.template = template;
        this.instanceName = name;
        this.adapter = adapter;
    }

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Deploy a virtual machine from " + this.template.getTemplatePath();
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        try {
            ResourcePool pool;
            ComputeResource computeResource = this.adapter.getHost(this.template.getDatacenter(), this.template.getHost());
            if (Strings.isNullOrEmpty((String)this.template.getResourcePool())) {
                ctx.logOutput("Using the whole host as a resource pool.");
                pool = computeResource.getResourcePool();
            } else {
                ctx.logOutput("Using resource pool " + this.template.getResourcePool());
                InventoryNavigator parent = new InventoryNavigator((ManagedEntity)this.adapter.getHost(this.template.getDatacenter(), this.template.getHost()));
                try {
                    pool = (ResourcePool)this.filterManagedEntities(parent.searchManagedEntities("ResourcePool"), this.template.getResourcePool());
                }
                catch (NoSuchElementException e) {
                    ctx.logError("Can not find resource pool " + this.template.getResourcePool(), (Throwable)e);
                    return StepExitCode.FAIL;
                }
            }
            VirtualMachine vmTemplate = this.adapter.getVm(this.template.getDatacenter(), this.template.getTemplatePath());
            VirtualMachineCloneSpec spec = new VirtualMachineCloneSpec();
            spec.setPowerOn(true);
            spec.setTemplate(false);
            spec.setLocation(new VirtualMachineRelocateSpec());
            spec.getLocation().setPool(pool.getMOR());
            if (!Strings.isNullOrEmpty((String)this.template.getDatastore())) {
                try {
                    spec.getLocation().setDatastore(this.filterManagedEntities((ManagedEntity[])computeResource.getDatastores(), this.template.getDatastore()).getMOR());
                }
                catch (NoSuchElementException e) {
                    ctx.logError("Can not find datastore " + this.template.getDatastore(), (Throwable)e);
                    return StepExitCode.FAIL;
                }
            }
            if (!Strings.isNullOrEmpty((String)this.template.getCustomization())) {
                CustomizationSpecManager csm = this.adapter.getSi().getCustomizationSpecManager();
                try {
                    ctx.logOutput("Using customization " + this.template.getCustomization());
                    spec.setCustomization(csm.getCustomizationSpec(this.template.getCustomization()).getSpec());
                }
                catch (NotFound e) {
                    ctx.logError("Can not find customization " + this.template.getCustomization(), (Throwable)e);
                    return StepExitCode.FAIL;
                }
            }
            spec.setConfig(new VirtualMachineConfigSpec());
            spec.getConfig().setName(this.instanceName);
            if (this.template.getMemory() != 0) {
                ctx.logOutput("Setting memory to " + this.template.getMemory() + " MB");
                spec.getConfig().setMemoryMB(Long.valueOf(this.template.getMemory()));
            }
            if (this.template.getCpus() != 0) {
                ctx.logOutput("Setting number of CPUs to " + this.template.getCpus());
                spec.getConfig().setNumCPUs(Integer.valueOf(this.template.getCpus()));
            }
            Folder destinationFolder = this.adapter.getVmFolder(this.template.getDatacenter(), this.template.getDestinationPath());
            Task task = vmTemplate.cloneVM_Task(destinationFolder, this.instanceName, spec);
            String expectedVmPath = VsphereUtils.vmPath(this.template.getDatacenter(), this.template.getDestinationPath(), this.instanceName);
            ContextHelper.wrapped((ExecutionContext)ctx).safeSet((Enum)ContextAttribute.USED_TEMPLATES, new ArrayList(), Arrays.asList(this.template));
            ContextHelper.wrapped((ExecutionContext)ctx).safeSet((Enum)ContextAttribute.CREATED_INSTANCES, new ArrayList(), Arrays.asList(expectedVmPath));
            ContextHelper.wrapped((ExecutionContext)ctx).safeSet((Enum)ContextAttribute.STARTED_TASKS, new ArrayList(), Arrays.asList(task.getMOR().getVal()));
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        return StepExitCode.SUCCESS;
    }

    private <T extends ManagedEntity> T filterManagedEntities(ManagedEntity[] entities, final String name) {
        return (T)((ManagedEntity)Iterables.getOnlyElement((Iterable)Collections2.filter(Arrays.asList(entities), (Predicate)new Predicate<ManagedEntity>(){

            public boolean apply(ManagedEntity rp) {
                return name.equals(rp.getName());
            }
        })));
    }
}

