/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.util;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import java.util.Collection;

public class ContextHelper {
    private ExecutionContext wrapped;

    private ContextHelper(ExecutionContext ctx) {
        this.wrapped = ctx;
    }

    public static ContextHelper wrapped(ExecutionContext context) {
        return new ContextHelper(context);
    }

    public <T> T safeGet(String key, T initialValue) {
        if (this.wrapped.getAttribute(key) == null) {
            this.wrapped.setAttribute(key, initialValue);
        }
        Object value = this.wrapped.getAttribute(key);
        return (T)value;
    }

    public <T> T safeGet(Enum<?> key, T initialValue) {
        return this.safeGet(key.name(), initialValue);
    }

    public <C, R extends Collection<C>, T extends Collection<C>> R safeSet(String key, R initialValue, T values) {
        R collection = this.safeGet(key, initialValue);
        collection.addAll(values);
        return collection;
    }

    public <C, R extends Collection<C>, T extends Collection<C>> R safeSet(Enum<?> key, R initialValue, T values) {
        return this.safeSet(key.name(), initialValue, values);
    }
}

