def findListenerPortServerIds(deployed):
    ### this function is *not found* if defined at top-level
    def toServerId(member):
            nodeName = AdminConfig.showAttribute(member,'nodeName')
            memberName = AdminConfig.showAttribute(member,'memberName')
            return AdminConfig.getid("/Node:%s/Server:%s" % (nodeName, memberName))

    containerId = validateNotEmpty(AdminConfig.getid(deployed.container.containmentPath), "Cannot find config id for container "+ deployed.container.containmentPath);

    if containerId.find('ServerCluster') > 0:
            return [toServerId(member) for member in AdminConfig.list("ClusterMember", containerId).splitlines()]
    else:
            return [containerId]

def findListenerPortServerIds2(deployed):
    containerId = validateNotEmpty(AdminConfig.getid(deployed.container.containmentPath), "Cannot find config id for container "+ deployed.container.containmentPath);
    containerType = AdminConfig.getObjectType(containerId)

    containers = []
    if containerType in ['Cell', 'Node']:
        containers = findAllContainers(deployed.container, True)

    servers = [AdminConfig.getid(container.containmentPath) for container in containers if container.type in ['was.ManagedServer']]

    return servers

