def wsadminToList(inStr):
	outList=[]
	if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
		inStr = inStr[1:-1]
		tmpList = inStr.split(" ")
	else:
		tmpList = inStr.split("\n")		#splits for Windows or Linux
	for item in tmpList:
		item = item.rstrip();			#removes any Windows "\r"
		if (len(item)>0):
			outList.append(item)
	return outList

def findDmgrServer(coreGroupServers):
	allServers = wsadminToList(coreGroupServers)
	for server in allServers:
		name = AdminConfig.showAttribute(server, 'serverName')
		if name == 'dmgr':
			return server
	return None

# move the dmgr server to the preferred coordinator servers of the DefaultCoreGroup
coregroup = AdminConfig.getid('/CoreGroup:%s' % 'DefaultCoreGroup')
coreGroupServers = AdminConfig.showAttribute(coregroup, 'coreGroupServers')
dmgr = findDmgrServer(coreGroupServers)
AdminConfig.modify(coregroup, '[[preferredCoordinatorServers %s]]' % dmgr)

print 'Configured coregroup with name ' + 'DefaultCoreGroup'
