def wsadminToList(inStr):
	outList=[]
	if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
		inStr = inStr[1:-1]
		tmpList = inStr.split(" ")
	else:
		tmpList = inStr.split("\n")		#splits for Windows or Linux
	for item in tmpList:
		item = item.rstrip();			#removes any Windows "\r"
		if (len(item)>0):
			outList.append(item)
	return outList

def addOrDeleteBasicAuth(supportedAuthMechList, addBasicAuthentication):
	if addBasicAuthentication:
		if supportedAuthMechList is None or supportedAuthMechList == '':
			supportedAuthMechList = 'BASICAUTH'
		else:
			if supportedAuthMechList.find("BASICAUTH") == -1:
				supportedAuthMechList = supportedAuthMechList + '|BASICAUTH'
	else:
		if supportedAuthMechList is not None and supportedAuthMechList != '':
			index = supportedAuthMechList.find('BASICAUTH')
			if index != -1:
				supportedAuthMechList = supportedAuthMechList[0:index] + supportedAuthMechList[index + len('BASICAUTH'):]
				index = supportedAuthMechList.find('||')
				if index != -1:
					supportedAuthMechList[0:index] + supportedAuthMechList[index + 1:]
				if supportedAuthMechList.startswith('|'):
					supportedAuthMechList = supportedAuthMechList[1:]
				if supportedAuthMechList.endswith('|'):
					supportedAuthMechList = supportedAuthMechList[0:len(supportedAuthMechList) - 1]
	return supportedAuthMechList

def hasSupportedAuthMechListProperty(object):
	try:
		value = AdminConfig.showAttribute(object, 'supportedAuthMechList')
		return 1
	except:
		return 0

def findLayerWithSupportedAuthMechListProperty(inOrOutBound, hasSupportedAuthMechListProperty):
	layers = AdminConfig.showAttribute(inOrOutBound, 'layers')
	allLayers = wsadminToList(layers)
	for layer in allLayers:
		if hasSupportedAuthMechListProperty(layer) == 1:
			return layer
	return None

def convertTransportValue(transportValue):
	if transportValue == 'TCP/IP':
		return 'Never'
	if transportValue == 'SSL-Required':
		return 'Required'
	if transportValue == 'SSL-Supported':
		return 'Supported'

security = AdminConfig.list('Security')
csi = AdminConfig.showAttribute(security, 'CSI' )
inbound = AdminConfig.showAttribute(csi, 'claims')
outbound = AdminConfig.showAttribute(csi, 'performs')

layer = findLayerWithSupportedAuthMechListProperty(inbound, hasSupportedAuthMechListProperty)
supportedAuthMechList = AdminConfig.showAttribute(layer, 'supportedAuthMechList')
authMechString = addOrDeleteBasicAuth(supportedAuthMechList, deployed.inboundBasicAuthentication)
AdminConfig.modify(layer, [['supportedAuthMechList', '%s' % authMechString ]] )
layer = findLayerWithSupportedAuthMechListProperty(outbound, hasSupportedAuthMechListProperty)
supportedAuthMechList = AdminConfig.showAttribute(layer, 'supportedAuthMechList')
authMechString = addOrDeleteBasicAuth(supportedAuthMechList, deployed.outboundBasicAuthentication)
AdminConfig.modify(layer, [['supportedAuthMechList', '%s' % authMechString ]] )

# next is in/outboundClientCertificateAuthentication (Supported|Required|Never)
AdminTask.configureCSIInbound('[-clientCertAuth %s]' % deployed.inboundClientCertificateAuthentication)
AdminTask.configureCSIOutbound('[-clientCertAuth %s]' % deployed.outboundClientCertificateAuthentication)

# next is in/outboundTransport (Supported|Required|TCP/IP)
value = convertTransportValue(deployed.inboundTransport)
AdminTask.configureCSIInbound('[-transportLayer %s]' % value)
value = convertTransportValue(deployed.outboundTransport)
AdminTask.configureCSIOutbound('[-transportLayer %s]' % value)

# finally ssl setting centrally managed, or specific
if deployed.inboundSslSettingsCentrallyManaged:
	AdminTask.configureCSIInbound('[-sslConfiguration ]')
else:
	AdminTask.configureCSIInbound('[-sslConfiguration CellDefaultSSLSettings]')
if deployed.outboundSslSettingsCentrallyManaged:
	AdminTask.configureCSIOutbound('[-sslConfiguration ]')
else:
	AdminTask.configureCSIOutbound('[-sslConfiguration CellDefaultSSLSettings]')
