def noneOrEmpty(string):
  return string is None or string == ''

jmsProviderContainmentPath = '%s/JMSProvider:%s' % (deployed.container.containmentPath, deployed.jmsProvider)
jmsProviderId = validateNotEmpty(AdminConfig.getid(jmsProviderContainmentPath), "Cannot find WebSphere JMS Provider " + deployed.jmsProvider);
args = [['type', deployed.genericJmsDestinationType]]
args.extend(toAdminConfigArgs(deployed.getExposedProperties(True)))

print "Creating %s for provider %s with args %s " % (deployed.wasType, jmsProviderId, args)
factory = AdminConfig.create(deployed.wasType, jmsProviderId, args)

# Support deprecated property 'authDataAliasContainer' (now 'containerAuthDataAlias')
if hasattr(deployed, 'authDataAliasContainer'):
    if not noneOrEmpty(deployed.authDataAliasContainer) and noneOrEmpty(deployed.containerAuthDataAlias):
        print "WARN: Property 'authDataAliasContainer' is deprecated and will be removed in a future version. Please use 'containerAuthDataAlias' instead."
        deployed.containerAuthDataAlias = deployed.authDataAliasContainer

# Set container-managed authentication properties
if not noneOrEmpty(deployed.containerAuthDataAlias):
    mappingArgs = [['authDataAlias', deployed.containerAuthDataAlias], ['mappingConfigAlias', deployed.mappingConfigAlias]]
    print "Creating MappingModule: %s" % (mappingArgs)
    AdminConfig.create('MappingModule', factory, mappingArgs)
    
# Set connection pool properties
poolArgs = [['connectionTimeout', deployed.connectionTimeout], ['maxConnections', deployed.maxConnections], ['minConnections', deployed.minConnections]]
print "Creating ConnectionPool: %s" % (poolArgs)
AdminConfig.create('ConnectionPool', factory, poolArgs,'connectionPool')
