/*
 * @(#)WasClusterSteps.java     2 Oct 2011
 *
 * Copyright © 2010 Andrew Phillips.
 *
 * ====================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ====================================================================
 */
package com.xebialabs.deployit.community.wasext.task;

import static java.lang.String.format;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.was.container.Cluster;

public class ClusterTasks {
    private static final String STOP_SCRIPT_PROPERTY = "stopScript";
    private static final String START_SCRIPT_PROPERTY = "startScript";
    private static final String STOP_ORDER_PROPERTY = "stopOrder";
    private static final String START_ORDER_PROPERTY = "startOrder";
    
    public static void stop(Cluster cluster, DeploymentPlanningContext ctx) {
        stop(cluster, ctx, cluster.<Integer>getProperty(STOP_ORDER_PROPERTY));
    }
    
    protected static void stop(Cluster cluster, DeploymentPlanningContext ctx, 
            int order) {
        ctx.addStep(new PythonDeploymentStep(order, cluster.getCell(), 
                cluster.<String>getProperty(STOP_SCRIPT_PROPERTY), 
                ImmutableMap.<String, Object>of("container", cluster), 
                format("Stop cluster '%s'", cluster.getName())));
    }
    
    public static void start(Cluster cluster, DeploymentPlanningContext ctx) {
        start(cluster, ctx, cluster.<Integer>getProperty(START_ORDER_PROPERTY)); 
    }

    protected static void start(Cluster cluster, DeploymentPlanningContext ctx,
            int order) {
        ctx.addStep(new PythonDeploymentStep(order, cluster.getCell(),
                cluster.<String>getProperty(START_SCRIPT_PROPERTY), 
                ImmutableMap.<String, Object>of("container", cluster), 
                format("Start cluster '%s'", cluster.getName())));
    }
    
    // override me!
    public static void restart(Cluster cluster, DeploymentPlanningContext ctx) {
        int startOrder = cluster.<Integer>getProperty(START_ORDER_PROPERTY);
        // allow steps to be injected in between if necessary
        stop(cluster, ctx, startOrder - 2);
        start(cluster, ctx, startOrder);
    }
}
