import sys

cluster = AdminConfig.getid('/ServerCluster:%s/' % (container.name))
if cluster != "":
    print "WARN: Cluster '%s' already exists. Doing nothing." % (container.name)
    sys.exit(0)

args = ['-clusterConfig', ['-clusterName', container.name]]
print "Creating cluster '%s'" % (container.name)
AdminTask.createCluster(args)

firstMember = True
for server in container.servers:
  serverArgs = ['-clusterName', container.name, '-memberConfig', ['-memberNode', server.nodeName, '-memberName', server.name, '-memberWeight', str(server.weight)]]
  if server.template is not None and server.template != '':
    if firstMember:
      serverArgs.append('-firstMember')
      serverArgs.append(['-templateName', server.template])
      firstMember = False
    else:
      print "WARN: Ignoring template '%s' since '%s' is not the first member of the cluster" % (server.template, server.name)
  print "Creating member server '%s' in cluster '%s': %s" % (server.name, container.name, serverArgs)
  AdminTask.createClusterMember(serverArgs)
  
print "Saving configuration"
AdminConfig.save()

for server in container.servers:
  nodeName = server.nodeName
  print "Synchronizing '%s'" % (nodeName)
  sync = AdminControl.completeObjectName("type=NodeSync,node=%s,*" % (nodeName));
  if sync == '':
    print >> sys.stderr, "Node '%s' does not exist or is not running" % (nodeName)
    sys.exit(1)
  AdminControl.invoke(sync, 'sync');
  print "Completed synchronization of '%s'" % (nodeName)
