package com.xebialabs.deployit.community.wasext.ctrltask;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.was.container.DeploymentManager;
import com.xebialabs.deployit.plugin.was.container.Node;
import java.util.List;
import java.util.Map;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;


public class FullCycleDmgrAndNodeAgents {

    private static final String STOP_WRAPPER_SCRIPT = "wasx/container/stopDmgrAndNodeAgents";
    private static final String START_WRAPPER_SCRIPT = "wasx/container/startDmgrAndNodeAgents";
    public static final String PROFILE_HOST = "profileHost";
    public static final String PROFILE_HOME = "profileHome";

    @Delegate(name = "CycleDmgrAndNodeAgents")
    public List<Step> cycleDmgrAndNodeAgents(ConfigurationItem ci, String method, Map<String,String> args) {
        checkArgument(ci.getType().equals(Type.valueOf(DeploymentManager.class)), "Control Task delegate can only be used with a DeploymentManager");

        DeploymentManager dmgr = (DeploymentManager) ci;
        Iterable<? extends Node> nodes = findAllNodeAgentWhoseProfileHomeIsSet(dmgr);
        List<Step> steps = newArrayList();
        Map<String,Object> commonCtx = newHashMap();
        commonCtx.put("args", args);
        commonCtx.put("deploymentManager",dmgr);

        addSteps(method, steps, dmgr, commonCtx, dmgr.getHost());

        for (Node node : nodes) {
            Map<String,Object> ctx = newHashMap(commonCtx);
            ctx.put("node",node);

            Host host = dmgr.getHost();
            if (node.hasProperty(PROFILE_HOST) && node.getProperty(PROFILE_HOST) != null) {
                host = node.getProperty(PROFILE_HOST);
            }
            addSteps(method, steps, node, ctx, host);
        }

        return steps;
    }

    private void addSteps(String method, List<Step> steps, ConfigurationItem ci, Map<String, Object> ctx, Host host) {
        if("restartDmgrAndAgents".equals(method)) {
            steps.add(stopStep(host, ctx, ci));
            steps.add(startStep(host, ctx, ci));
        } else if("stopDmgrAndAgents".equals(method)) {
            steps.add(stopStep(host, ctx, ci));
        } else if("startDmgrAndAgents".equals(method)) {
            steps.add(startStep(host, ctx, ci));
        }
    }

    private Step stopStep(Host host, Map<String,Object> ctx, ConfigurationItem ci) {
        return new ScriptExecutionStep(1, STOP_WRAPPER_SCRIPT, host, ctx, "Stopping " + ci);
    }

    private Step startStep(Host host, Map<String,Object> ctx, ConfigurationItem ci) {
        return new ScriptExecutionStep(1, START_WRAPPER_SCRIPT, host, ctx, "Starting " + ci);
    }

    private Iterable<? extends Node> findAllNodeAgentWhoseProfileHomeIsSet(DeploymentManager dmgr) {
        return Iterables.filter(dmgr.getNodes(), new Predicate<Node>() {
            @Override
            public boolean apply(Node input) {
                if (input.hasProperty(PROFILE_HOME) && !Strings.isNullOrEmpty(input.<String>getProperty(PROFILE_HOME))){
                    return true;
                }
                return false;
            }
        });

    }
}
