/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.planning;

import com.google.common.collect.Iterables;
import com.xebialabs.deployit.community.wasext.task.DatasourceTasks;
import com.xebialabs.deployit.community.wasext.util.Predicates;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.SingleTypeContributor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedResource;

public class TestDatasourceConnections
extends SingleTypeContributor<ExtensibleDeployedResource> {
    private static final Type DATASOURCE_TYPE = Type.valueOf((String)"was.Datasource");
    private static final String DATASOURCE_TEST_CONNECTION_PROPERTY = "testConnection";

    public TestDatasourceConnections() {
        super(DATASOURCE_TYPE);
    }

    @Contributor
    public void testConnections(Deltas deltas, DeploymentPlanningContext ctx) {
        this.filterDeltas(deltas.getDeltas());
        Iterable createdOrModifiedDatasources = Iterables.concat((Iterable)this.deployedsCreated, (Iterable)Iterables.transform((Iterable)this.deployedsModified, Predicates.extractDeployed()));
        for (Deployed datasource : createdOrModifiedDatasources) {
            if (!Boolean.TRUE.equals(datasource.getProperty(DATASOURCE_TEST_CONNECTION_PROPERTY))) continue;
            DatasourceTasks.testConnection((ExtensibleDeployedResource)datasource, ctx);
        }
    }
}

