def wsadminToList(inStr):
    outList=[]
    if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
        inStr = inStr[1:-1]
        tmpList = inStr.split(" ")
    else:
        tmpList = inStr.split("\n")        #splits for Windows or Linux
    for item in tmpList:
        item = item.rstrip();            #removes any Windows "\r"
        if (len(item)>0):
            outList.append(item)
    return outList

# first make sure that the 'Enable trust association' checkbox is checked
security = AdminConfig.list('Security')
activeAuthMechanism = AdminConfig.showAttribute(security, 'activeAuthMechanism')
trustAssociation = AdminConfig.showAttribute(activeAuthMechanism, 'trustAssociation')
AdminConfig.modify(trustAssociation, '[[enabled "true"]]')

if hasattr(deployed, 'removeOtherInterceptorsStartingWith') and deployed.removeOtherInterceptorsStartingWith != '':
    interceptors = AdminConfig.showAttribute(trustAssociation, 'interceptors')
    allInterceptors = wsadminToList(interceptors)
    print 'Deleting interceptors if its className starts with ' + deployed.removeOtherInterceptorsStartingWith
    for interceptor in allInterceptors:
        interceptorClassName = AdminConfig.showAttribute(interceptor, 'interceptorClassName')
        index = interceptorClassName.find(deployed.removeOtherInterceptorsStartingWith)
        if index == 0:
            AdminTask.unconfigureInterceptor('[-interceptor %s ]' % interceptorClassName)
            print 'Interceptor ' + interceptorClassName + ' now deleted'

def buildPropertiesString():
    propsString = ''
    for key, value in deployed.customProperties.items():
        propsString = propsString + '"%s=%s",' % (key, value)
    if propsString != '':
        propsString = propsString[:-1]
    return propsString
    
print 'Trust association is now enabled. Adding interceptor with classname ' + deployed.interceptorClassName + '...'
propertiesString = buildPropertiesString() 
AdminTask.configureInterceptor('[-interceptor %s -customProperties [%s] ]' % (deployed.interceptorClassName, propertiesString))

print 'Interceptor added'


