def discoverAndInspectResourceEnvironmentEntry(container):
    resourceEnvProviderContainmentPath = '%s/ResourceEnvironmentProvider:/' % (container.containmentPath)
    try:
        resourceEnvProviders = validateNotEmpty(wsadminToList(AdminConfig.getid(resourceEnvProviderContainmentPath)), "Cannot locate Resource Environment Provider ContainmentPath '%s'" % (resourceEnvProviderContainmentPath))
        for providerId in resourceEnvProviders:
            resEnvEntries = wsadminToList(AdminConfig.list("ResourceEnvEntry", providerId))
            for envEntry in resEnvEntries:
                deployedName = AdminConfig.showAttribute(envEntry, "name")
                deployedId = container.id + '/' + deployedName
                discovered(deployedId, prototype.type)
                inspectDeployedProperties(deployedId, deployedName, envEntry, prototype)
                inspectNestedResourceproperties(deployedId, envEntry, "provider")
                inspectNestedJ2EEResourceProperties(deployedId, envEntry, "propertySet", "customProperties")
                inspectedItem(deployedId)
    except:
        print "Unable to discover ResourceEnvEntry on container:%s" % (container.containmentPath)


def inspectNestedResourceproperties(deployedId, envEntry, nestedProperty):
    nestedPropId = AdminConfig.showAttribute(envEntry, nestedProperty)
    inspectedProperty(deployedId, nestedProperty, AdminConfig.showAttribute(nestedPropId, "name"))

for c in findAllContainers(container):
    discoverAndInspectResourceEnvironmentEntry(c)
