#  Override function from was/runtime/base.py
def inspectAdminConfigPropertiesCallback(container,prototype, canHandleAdminConfigPropertyTypeCallback, adminConfigPropertyTypeInspectCallback, listObjectsInContainerCallback=None, appendTypeToName=False, stringEncoding=None):
    print "Retrieving list of %s objects in container %s" % (prototype.wasType, container.name)
    if listObjectsInContainerCallback:
        AdminConfigPropertiesList = listObjectsInContainerCallback(container, prototype)
    else:
        AdminConfigPropertiesList = wsadminToList(AdminConfig.list(prototype.wasType, AdminConfig.getid(container.containmentPath)))
    for prop in AdminConfigPropertiesList:
        if canHandleAdminConfigPropertyTypeCallback is None or canHandleAdminConfigPropertyTypeCallback(p):
            # protect XLD ids by replacing slash with underscore
            name = AdminConfig.showAttribute(prop, 'name').replace("/","_")
            print "Discovered %s %s in container %s" % (prototype.type, name, container.name)

            if appendTypeToName:
                deployedId = container.id + '/' + name + '_' + prototype.type
            else:
                deployedId = container.id + '/' + name
            discovered(deployedId, prototype.type)
            inspectedProperty(deployedId, 'wasName', name)
            adminConfigPropertyTypeInspectCallback(deployedId, name, prop, prototype, getVersion(container), stringEncoding)
            inspectedItem(deployedId)

def listNamespaceBindings(container, prototype):
    return wsadminToList(AdminConfig.getid('%s/%s:/' % (container.containmentPath, prototype.wasType)))

def inspectNamespaceBinding(deployedId, deployedName, resourceId, prototype, wasVersion, stringEncoding=None):
    inspectDeployedProperties(deployedId, deployedName, resourceId, prototype)
    # discover new bindingIdentifier property in CI
    inspectedProperty(deployedId, 'bindingIdentifier', AdminConfig.showAttribute(resourceId, 'name'))
    value=AdminConfig.showAttribute(resourceId, 'stringToBind')
    if stringEncoding:
        if wasVersion == 'WAS_90':
            value = value.encode(stringEncoding)
        else:
            value = unicode(value, stringEncoding)
    inspectedProperty(deployedId, 'value', value)

discoverAndInspectResources(container, prototype, listNamespaceBindings, inspectNamespaceBinding, appendTypeToName, stringEncoding)