package com.xebialabs.deployit.plugin.was.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.services.SearchParameters;
import com.xebialabs.deployit.plugin.api.udm.CandidateValuesFilter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.was.container.WasContainer;

public class WebSphereCellCandidateValuesFilter {

    @CandidateValuesFilter(name = "was-by-cell")
    public static SearchParameters filterByCell(ConfigurationItem ci, PropertyDescriptor property) {
        SearchParameters params = new SearchParameters();
        params.setType(property.getReferencedType());
        if(ci instanceof Deployed) {
            Container container = ((Deployed) ci).getContainer();
            if(container instanceof WasContainer) {
                params.setAncestor(((WasContainer) container).getCell().getId());
            }
        }
        return params;
    }

    private static Logger logger = LoggerFactory.getLogger(WebSphereCellCandidateValuesFilter.class);

}
