package com.xebialabs.deployit.plugin.was.contributor;

import java.util.List;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

import static com.google.common.collect.Iterables.transform;
import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.deployit.plugin.was.util.Predicates.deltaOf;

public abstract class CollectDeployedsOfTypesContributor<D extends Deployed<?, ?>> {
    protected final List<Type> typesOfInterest;

    protected List<D> deployedsCreated = newArrayList();
    protected List<TypedDelta> deployedsModified = newArrayList();
    protected List<TypedDelta> deployedsNoop = newArrayList();
    protected List<D> deployedsRemoved = newArrayList();

    protected CollectDeployedsOfTypesContributor(Type typeOfDeployed) {
        typesOfInterest = newArrayList(typeOfDeployed);
    }

    protected CollectDeployedsOfTypesContributor(List<Type> typeOfDeployed) {
        typesOfInterest = typeOfDeployed;
    }

    protected Predicate<Delta> isOfType() {
        if(typesOfInterest.size() == 1) {
            return deltaOf(typesOfInterest.get(0));
        }
        return Predicates.or(transform(typesOfInterest, new Function<Type, Predicate<Delta>>() {
            @Override
            public Predicate<Delta> apply(Type input) {
                return deltaOf(input);
            }
        }));
    }

    @SuppressWarnings("unchecked")
    protected void filterDeltas(List<Delta> deltas) {
        Predicate<Delta> isOfType = isOfType();
        for(Delta d : deltas) {
            if(isOfType.apply(d)) {
                switch(d.getOperation()) {
                case CREATE:
                    deployedsCreated.add((D)d.getDeployed());
                    break;
                case MODIFY:
                    deployedsModified.add(new TypedDelta(d));
                    break;
                case NOOP:
                    deployedsNoop.add(new TypedDelta(d));
                    break;
                case DESTROY:
                    deployedsRemoved.add((D)d.getPrevious());
                    break;
                }
            }
        }
    }

    @SuppressWarnings("serial")
    protected class TypedDelta implements Delta {
        private final Delta delegate;

        private TypedDelta(Delta delegate) {
            this.delegate = delegate;
        }

        @Override
        public Operation getOperation() {
            return delegate.getOperation();
        }

        @SuppressWarnings("unchecked")
        @Override
        public D getPrevious() {
            return (D) delegate.getPrevious();
        }

        @SuppressWarnings("unchecked")
        @Override
        public D getDeployed() {
            return (D) delegate.getDeployed();
        }

        @Override
        public List<String> getIntermediateCheckpoints() {
            return delegate.getIntermediateCheckpoints();
        }


    }
}
