package com.xebialabs.deployit.plugin.was.validator;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;

@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = LongRange.Validator.class, type = "was-long-range")
@ApplicableTo(PropertyKind.STRING)
public @interface LongRange {
    String RANGE_ERROR_MESSAGE = "Value %s is not in range [%s, %s]";
    String FORMAT_ERROR_MESSAGE = "Value %s is not a valid number";
    String MINMAX_ERROR_MESSAGE = "Invalid minimum or maximum value minimum is %s, maximum is %s";
    // ReflectionUtils does not support long, bork around it
    String MIN_VALUE = "" + Long.MIN_VALUE;
    String MAX_VALUE = "" + Long.MAX_VALUE;

    String minimum() default MIN_VALUE;
    String maximum() default MAX_VALUE;
    String rangeErrorMessage() default RANGE_ERROR_MESSAGE;
    String formatErrorMessage() default FORMAT_ERROR_MESSAGE;
    String minMaxErrorMessage() default MINMAX_ERROR_MESSAGE;

    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<String> {
        private String minimum = LongRange.MIN_VALUE;
        private String maximum = LongRange.MAX_VALUE;
        private String rangeErrorMessage = LongRange.RANGE_ERROR_MESSAGE;
        private String formatErrorMessage = LongRange.FORMAT_ERROR_MESSAGE;
        private String minMaxErrorMessage = LongRange.MINMAX_ERROR_MESSAGE;

        @Override
        public void validate(final String value, final ValidationContext context) {
            if (value == null) {
                return;
            }
            try {
                long min = Long.parseLong(minimum);
                long max = Long.parseLong(maximum);
                try {
                    long longValue = Long.parseLong(value);
                    if (longValue < min || longValue > max) {
                        context.error(rangeErrorMessage, value, minimum, maximum);
                    }
                } catch (NumberFormatException e) {
                    context.error(formatErrorMessage, value);
                }
            } catch (NumberFormatException e) {
                context.error(minMaxErrorMessage, minimum, maximum);
            }
        }
    }
}
