/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import java.util.Collection;
import java.util.Collections;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCell;

/**
 * Retrieves the nodes, clusters, and servers from a cell.
 */
@SuppressWarnings("serial")
public class RetrieveWasSubtypesStep extends WasStepBase {

	public RetrieveWasSubtypesStep(WasCell cell) {
		super(cell);
		setDescription("Retrieve nodes, clusters, and servers from cell " + cell);
	}

	public boolean execute(StepExecutionContext ctx) {
		ctx.logOutput("Retrieving nodes...");
		Collection<String> nodes = cell.getObjectInfoWithSubLevelByTypeNamesOnly(ctx, "/Cell/" + cell.getCellName(), "Node");
		if (nodes == null) {
			nodes = Collections.emptySet();
		}
		ctx.setAttribute("WasNode", nodes);

		ctx.logOutput("Retrieving nodes done. Retrieving clusters...");
		Collection<String> clusters = cell.getObjectInfoWithSubLevelByTypeNamesOnly(ctx, "/Cell/" + cell.getCellName(), "ServerCluster");
		if (clusters == null) {
			clusters = Collections.emptySet();
		}
		ctx.setAttribute("WasCluster", clusters);

		ctx.logOutput("Retrieving clusters done. Retrieving servers...");
		Collection<String> servers = cell.getObjectInfoWithSubLevelByTypeNamesOnly(ctx, "/Cell/" + cell.getCellName(), "Server");
		if (servers == null) {
			servers = Collections.emptySet();
		}
		ctx.setAttribute("WasServer", servers);

		ctx.logOutput("");
		ctx.logOutput("Retrieving servers done. Will now discover properties of nodes, clusters, and servers found...");

		return true;
	}

}
