/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.ci;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.Discoverable;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", discoverable = true, description = "A WebSphere cluster managed by a deployment manager (WAS ND)")
public class WasCluster extends BaseConfigurationItem implements WasTarget, Discoverable<WasCluster> {

	@ConfigurationItemProperty(required = true, asContainment = true, label = "Deployment manager that manages this this cluster")
	private WasDeploymentManager cell;

	@ConfigurationItemProperty(required = true, identifying = true, label = "WebSphere name", description = "Name of the WebSphere cluster, e.g. cluster1")
	private String name;

	@ConfigurationItemProperty(label = "Cluster server members", description = "Servers that are part of this cluster")
	private Set<WasManagedServer> servers;

	public void setServers(Set<WasManagedServer> servers) {
		this.servers = servers;
	}

	public Set<WasManagedServer> getServers() {
		return servers;
	}

	public WasDeploymentManager getCell() {
		return cell;
	}

	public void setCell(WasDeploymentManager cell) {
		this.cell = cell;
	}

	public Map<WasNodeAgent, List<String>> getServerNamesPerNode() {
		Map<WasNodeAgent, List<String>> serverNamesPerNode = new HashMap<WasNodeAgent, List<String>>();
		for (WasManagedServer server : servers) {
			WasNodeAgent node = server.getNode();
			List<String> serverNames = serverNamesPerNode.get(node);
			if (serverNames == null) {
				serverNames = new ArrayList<String>();
				serverNamesPerNode.put(node, serverNames);
			}
			serverNames.add(server.getName());
		}
		return serverNamesPerNode;
	}

	public Collection<WasNodeAgent> getNodes() {
		Set<WasNodeAgent> nodes = new HashSet<WasNodeAgent>();
		for (WasManagedServer server : servers) {
			nodes.add(server.getNode());
		}
		return nodes;
	}

	public static String getLogPathForMember(String memberServerName, String logPrefix) {
		if (StringUtils.isBlank(logPrefix)) {
			return logPrefix;
		} else {
			return logPrefix + memberServerName + ".txt";
		}
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public WasCluster discover(Map<String, Object> info, ChangePlan cp) {
		return this; // TODO implement this
	}

	public WasCluster discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
		return null;
	}

	public String getWasConfigIdType() {
		return "ServerCluster";
	}

	public String getWasTargetType() {
		return "cluster";
	}

	public String getShortTypeDescription() {
		return "cluster";
	}

	public List<String> getApplicationManagerObjectNames() {
		Map<WasNodeAgent, List<String>> serverNamesPerNode = getServerNamesPerNode();
		ArrayList<String> applicationManagerObjectNames = new ArrayList<String>();
		for (Map.Entry<WasNodeAgent, List<String>> each : serverNamesPerNode.entrySet()) {
			WasNodeAgent eachNode = each.getKey();
			List<String> eachNodeServerNames = each.getValue();
			for (String eachServerName : eachNodeServerNames) {
				applicationManagerObjectNames.add("cell=" + cell.getCellName() + ",node=" + eachNode.getName() + ",type=ApplicationManager,process="
				        + eachServerName + ",*");
			}
		}
		return applicationManagerObjectNames;
	}

}