/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.was.ci.WasDefaultQueueConnectionFactory;
import com.xebialabs.deployit.plugin.was.ci.WasJmsConnectionFactory;
import com.xebialabs.deployit.plugin.was.ci.WasResourceMapping;
import com.xebialabs.deployit.plugin.was.ci.WasSibJmsQueueConnectionFactory;
import com.xebialabs.deployit.plugin.was.ci.WasSibJmsTopicConnectionFactory;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.ci.WasWmqQueueConnectionFactory;
import com.xebialabs.deployit.plugin.was.ci.WasWmqTopicConnectionFactory;
import com.xebialabs.deployit.plugin.was.step.CreateWasDefaultQueueConnectionFactoryStep;
import com.xebialabs.deployit.plugin.was.step.CreateWasSibJmsQueueConnectionFactoryStep;
import com.xebialabs.deployit.plugin.was.step.CreateWasSibJmsTopicConnectionFactoryStep;
import com.xebialabs.deployit.plugin.was.step.CreateWasWmqQueueConnectionFactoryStep;
import com.xebialabs.deployit.plugin.was.step.CreateWasWmqTopicConnectionFactoryStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasDefaultQueueConnectionFactoryStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasSibJmsQueueConnectionFactoryStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasSibJmsTopicConnectionFactoryStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasWmqQueueConnectionFactoryStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasWmqTopicConnectionFactoryStep;

public class WasJmsConnectionFactoryToWasTargetMapper extends MappingAgnosticStepGeneratingMapper<WasJmsConnectionFactory, WasResourceMapping, WasTarget> {

	public WasJmsConnectionFactoryToWasTargetMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WasJmsConnectionFactory resource, WasTarget target, List<Step> steps) {
		if (resource instanceof WasWmqQueueConnectionFactory) {
			steps.add(new CreateWasWmqQueueConnectionFactoryStep(target, (WasWmqQueueConnectionFactory) resource));
		} else if (resource instanceof WasSibJmsQueueConnectionFactory) {
			steps.add(new CreateWasSibJmsQueueConnectionFactoryStep(target, (WasSibJmsQueueConnectionFactory) resource));
		} else if (resource instanceof WasDefaultQueueConnectionFactory) {
			steps.add(new CreateWasDefaultQueueConnectionFactoryStep(target, (WasDefaultQueueConnectionFactory) resource));
		} else if (resource instanceof WasWmqTopicConnectionFactory) {
			steps.add(new CreateWasWmqTopicConnectionFactoryStep(target, (WasWmqTopicConnectionFactory) resource));
		} else if (resource instanceof WasSibJmsTopicConnectionFactory) {
			steps.add(new CreateWasSibJmsTopicConnectionFactoryStep(target, (WasSibJmsTopicConnectionFactory) resource));
		}			
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WasJmsConnectionFactory resource, WasTarget target, List<Step> steps) {
		if (resource instanceof WasWmqQueueConnectionFactory) {
			steps.add(new DestroyWasWmqQueueConnectionFactoryStep(target, (WasWmqQueueConnectionFactory) resource));
		} else if (resource instanceof WasSibJmsQueueConnectionFactory) {
			steps.add(new DestroyWasSibJmsQueueConnectionFactoryStep(target, (WasSibJmsQueueConnectionFactory) resource));
		} else if (resource instanceof WasDefaultQueueConnectionFactory) {
			steps.add(new DestroyWasDefaultQueueConnectionFactoryStep(target, (WasDefaultQueueConnectionFactory) resource));
		} else if (resource instanceof WasWmqTopicConnectionFactory) {
			steps.add(new DestroyWasWmqTopicConnectionFactoryStep(target, (WasWmqTopicConnectionFactory) resource));
		} else if (resource instanceof WasSibJmsTopicConnectionFactory) {
			steps.add(new DestroyWasSibJmsTopicConnectionFactoryStep(target, (WasSibJmsTopicConnectionFactory) resource));
		}		
	}

}
