/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.was.ci.WasDefaultQueue;
import com.xebialabs.deployit.plugin.was.ci.WasJmsQueue;
import com.xebialabs.deployit.plugin.was.ci.WasResourceMapping;
import com.xebialabs.deployit.plugin.was.ci.WasSibJmsQueue;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.ci.WasWmqQueue;
import com.xebialabs.deployit.plugin.was.step.CreateWasDefaultQueueStep;
import com.xebialabs.deployit.plugin.was.step.CreateWasSibJmsQueueStep;
import com.xebialabs.deployit.plugin.was.step.CreateWasWmqQueueStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasDefaultQueueStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasSibJmsQueueStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasWmqQueueStep;

public class WasJmsQueueToWasTargetMapper extends MappingAgnosticStepGeneratingMapper<WasJmsQueue, WasResourceMapping, WasTarget> {

	public WasJmsQueueToWasTargetMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WasJmsQueue resource, WasTarget target, List<Step> steps) {
		if (resource instanceof WasWmqQueue) {
			steps.add(new CreateWasWmqQueueStep(target, (WasWmqQueue) resource));
		} else if (resource instanceof WasSibJmsQueue) {
			steps.add(new CreateWasSibJmsQueueStep(target, (WasSibJmsQueue) resource));
		} else if (resource instanceof WasDefaultQueue) {
			steps.add(new CreateWasDefaultQueueStep(target, (WasDefaultQueue) resource));
		}
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WasJmsQueue resource, WasTarget target, List<Step> steps) {
		if (resource instanceof WasWmqQueue) {
			steps.add(new DestroyWasWmqQueueStep(target, (WasWmqQueue) resource));
		} else if (resource instanceof WasSibJmsQueue) {
			steps.add(new DestroyWasSibJmsQueueStep(target, (WasSibJmsQueue) resource));
		} else if (resource instanceof WasDefaultQueue) {
			steps.add(new DestroyWasDefaultQueueStep(target, (WasDefaultQueue) resource));
		}
	}

}
