/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.ci;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.plugin.was.ci.WasFileServing;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class WarsWebserversVirtualHostMapping
implements Serializable {
    @ConfigurationItemProperty(size=ConfigurationItemProperty.Size.LARGE)
    private String warName;
    @ConfigurationItemProperty(size=ConfigurationItemProperty.Size.LARGE)
    private String webserver;
    @ConfigurationItemProperty(size=ConfigurationItemProperty.Size.LARGE)
    private String virtualHost;
    @ConfigurationItemProperty(size=ConfigurationItemProperty.Size.LARGE)
    private String virtualHostAlias;
    @ConfigurationItemProperty(size=ConfigurationItemProperty.Size.LARGE, description="Set File Serving enabled to WAR")
    private WasFileServing fileServing = WasFileServing.DO_NOT_OVERRIDE;
    private Set<WasManagedApacheHttpdServer> webservers = Sets.newHashSet();

    public WarsWebserversVirtualHostMapping() {
    }

    public WarsWebserversVirtualHostMapping(String warName, String webserver, String virtualHost, String virtualHostAlias) {
        this(warName, webserver, virtualHost, virtualHostAlias, WasFileServing.DO_NOT_OVERRIDE);
    }

    public WarsWebserversVirtualHostMapping(String warName, String webserver, String virtualHost, String virtualHostAlias, WasFileServing fileServing) {
        this.warName = warName;
        this.webserver = webserver;
        this.virtualHost = virtualHost;
        this.virtualHostAlias = virtualHostAlias;
        this.fileServing = fileServing;
    }

    public String getWarName() {
        return this.warName;
    }

    public void setWarName(String warName) {
        this.warName = warName;
    }

    public String getWebserver() {
        return this.webserver;
    }

    public void setWebserver(String webserver) {
        this.webserver = webserver;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public WasFileServing getFileServing() {
        return this.fileServing;
    }

    public void setFileServing(WasFileServing fileServing) {
        this.fileServing = fileServing;
    }

    public Set<WasManagedApacheHttpdServer> getWebservers() {
        return this.webservers;
    }

    public void setWebservers(Set<WasManagedApacheHttpdServer> webservers) {
        this.webservers = webservers;
    }

    public String getVirtualHostAlias() {
        return this.virtualHostAlias;
    }

    public void setVirtualHostAlias(String virtualHostAlias) {
        this.virtualHostAlias = virtualHostAlias;
    }

    public boolean isWarLevelMappingPresent() {
        return StringUtils.isNotBlank((String)this.warName) && StringUtils.isNotBlank((String)this.webserver);
    }

    public boolean isWarLevelVirtualHostMappingPresent() {
        return StringUtils.isNotBlank((String)this.warName) && StringUtils.isNotBlank((String)this.virtualHost) && StringUtils.isNotBlank((String)this.virtualHostAlias);
    }
}

