/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.plugin.was.ci.WarsWebserversVirtualHostMapping;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasEarMapping;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasManagedServer;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.mapper.JeeWebArtifactToWasTargetMapper;
import com.xebialabs.deployit.plugin.was.step.WasDeployApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStartApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStopApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasUndeployApplicationStep;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class EarToWasServerMapper
extends JeeWebArtifactToWasTargetMapper<Ear, WasEarMapping, WasManagedServer> {
    public EarToWasServerMapper(Change<Deployment> change) {
        super(change, false);
    }

    @Override
    protected void generateDeployStep(Ear artifact, WasEarMapping mapping, WasManagedServer server, Collection<WasManagedApacheHttpdServer> webservers, List<Step> steps) {
        steps.add(new WasDeployApplicationStep(server.getCell(), mapping.getSource(), Collections.singleton(server), webservers, artifact.getName(), mapping.getSharedLibraries(), mapping.getStartingWeight(), mapping.getClassLoaderMode(), mapping.getClassLoaderPolicy(), mapping.getWarClassLoaderMapping(), mapping.getSecurityRoleUserGroupMappings(), this.getUpdatedWebserversMapping(mapping)));
    }

    @Override
    protected void generateUndeployStep(Ear artifact, WasManagedServer server, WasEarMapping mapping, List<Step> steps) {
        steps.add(new WasUndeployApplicationStep((WasCell)server.getCell(), mapping.getSource()));
    }

    @Override
    protected void generateStartStep(Ear artifact, WasManagedServer server, WasEarMapping mapping, List<Step> steps) {
        steps.add(new WasStartApplicationStep((WasTarget)server, mapping.getSource()));
    }

    @Override
    protected void generateStopStep(Ear artifact, WasManagedServer server, WasEarMapping mapping, List<Step> steps) {
        steps.add(new WasStopApplicationStep((WasTarget)server, mapping.getSource()));
    }

    @Override
    protected String getVirtualHostFromMapping(WasEarMapping mapping) {
        return mapping.getVirtualHost();
    }

    public void setDefaults(Deployment d, WasEarMapping m) {
        m.setVirtualHost(d.getVhostDefinition());
    }

    @Override
    protected List<WarsWebserversVirtualHostMapping> getWebserversAndVirtualHostPerWar(WasEarMapping mapping) {
        return mapping.getWarsWebserversVHMapping();
    }

    @Override
    protected List<WarsWebserversVirtualHostMapping> getFileServingEnabledPerWars(WasEarMapping mapping) {
        return this.getWebserversAndVirtualHostPerWar(mapping);
    }
}

