/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasSibJmsActivationSpec;
import com.xebialabs.deployit.plugin.was.ci.WasSibJmsQueue;
import com.xebialabs.deployit.plugin.was.ci.WasSibJmsTarget;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CreateWasSibJmsActivationSpecStep
extends WasStepBase
implements Step {
    private static String CREATE_SIB_JMS_AS_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/create-sib-jms-activation-spec.py";
    private WasSibJmsActivationSpec as;
    private WasTarget target;

    public CreateWasSibJmsActivationSpecStep(WasTarget target, WasSibJmsActivationSpec as) {
        super(target.getCell());
        this.as = as;
        this.target = target;
        this.setDescription("Create WebSphere Activation Specification " + as + " in " + target.getShortTypeDescription() + " " + target + " using the Default messaging provider");
    }

    public boolean execute(StepExecutionContext ctx) {
        HashMap<String, Serializable> context = new HashMap<String, Serializable>();
        context.put("as", (Serializable)((Object)this.as));
        int res = this.executeWsadminJythonScriptResource(ctx, context, CREATE_SIB_JMS_AS_SCRIPT_RESOURCE_PATH, this.getArgs().toArray(new String[0]));
        return res == 0;
    }

    private List<String> getArgs() {
        WasSibJmsTarget jmsTarget = this.as.getDestination();
        ArrayList args = Lists.newArrayList();
        String targetContainmentPath = "/" + this.target.getWasConfigIdType() + ":" + this.target.getName();
        args.add(targetContainmentPath);
        args.add(jmsTarget.getJndiName());
        args.add(jmsTarget instanceof WasSibJmsQueue ? "Queue" : "Topic");
        args.add(jmsTarget.getBusName());
        return args;
    }
}

