/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasClassLoaderPolicyAndMode;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieveWasServerApplicationServerPropertiesStep
extends WasStepBase {
    private WasServer server;
    private static final Logger logger = LoggerFactory.getLogger(RetrieveWasServerApplicationServerPropertiesStep.class);

    public RetrieveWasServerApplicationServerPropertiesStep(WasServer server) {
        super(server.getCell());
        this.server = server;
        this.setDescription("Retrieve ApplicationServer properties of server " + server);
    }

    public boolean execute(StepExecutionContext ctx) {
        ctx.logOutput("Retrieving server application class loader policies and mode");
        Map<String, String> webContainerProperties = this.cell.getObjectInfoWithSubLevelByType(ctx, "/Server:" + this.server.getName(), "ApplicationServer");
        if (webContainerProperties == null) {
            ctx.logError("Server " + this.server + "with technical name " + this.server.getName() + " does not exist in cell " + this.cell);
            return false;
        }
        String applicationClassLoaderPolicy = webContainerProperties.get("applicationClassLoaderPolicy");
        String applicationClassLoadingMode = webContainerProperties.get("applicationClassLoadingMode");
        if ("MULTIPLE".equalsIgnoreCase(applicationClassLoaderPolicy)) {
            this.server.setApplicationClassLoaderPolicyAndMode(WasClassLoaderPolicyAndMode.MULTIPLE);
        } else if ("SINGLE".equals(applicationClassLoaderPolicy)) {
            if ("PARENT_FIRST".equalsIgnoreCase(applicationClassLoadingMode)) {
                this.server.setApplicationClassLoaderPolicyAndMode(WasClassLoaderPolicyAndMode.SINGLE_PARENT_FIRST);
            } else if ("PARENT_LAST".equalsIgnoreCase(applicationClassLoadingMode)) {
                this.server.setApplicationClassLoaderPolicyAndMode(WasClassLoaderPolicyAndMode.SINGLE_PARENT_LAST);
            } else {
                logger.warn("Unknown application class loader mode: " + applicationClassLoadingMode);
            }
        } else {
            logger.warn("Unknown application class loader policy: " + applicationClassLoaderPolicy);
        }
        return true;
    }
}

