/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import java.util.Map;

public class RetrieveWasServerSessionManagerDefaultCookiePropertiesStep
extends WasStepBase {
    private WasServer server;

    public RetrieveWasServerSessionManagerDefaultCookiePropertiesStep(WasServer server) {
        super(server.getCell());
        this.server = server;
        this.setDescription("Retrieve SessionManager/defaultCookieSettings properties of server " + server);
    }

    public boolean execute(StepExecutionContext ctx) {
        Map<String, String> sessionManagerDefaultCookieProperties = this.cell.getObjectInfoWithSubLevelByTypeAndName(ctx, "/Server:" + this.server.getName(), "SessionManager", "defaultCookieSettings");
        if (sessionManagerDefaultCookieProperties == null) {
            ctx.logError("Server " + this.server + "with technical name " + this.server.getName() + " does not exist in cell " + this.cell);
            return false;
        }
        this.server.setCookieDomain(sessionManagerDefaultCookieProperties.get("domain"));
        this.server.setCookieName(sessionManagerDefaultCookieProperties.get("name"));
        this.server.setCookiePath(sessionManagerDefaultCookieProperties.get("path"));
        return true;
    }
}

