/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.container;

import static com.google.common.collect.Maps.newHashMap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;

@SuppressWarnings("serial")
@Metadata(description = "A WebSphere cluster managed by a deployment manager (WAS ND)")
public class Cluster extends BaseConfigurationItem implements WasAppContainer {

	@Property(required = true, asContainment = true, label = "Deployment manager that manages this this cluster")
	private DeploymentManager cell;

	@Property(label = "Cluster members", description = "Servers that are part of this cluster")
	private Set<ManagedServer> servers;

	@Override
	public DeploymentManager getCell() {
		return cell;
	}

	@Override
	public PythonManagingContainer getManagingContainer() {
		return getCell();
	}

	@Override
	public String getCellName() {
		return getCell().getName();
	}

	public void setCell(DeploymentManager cell) {
		this.cell = cell;
	}

	public void setServers(Set<ManagedServer> servers) {
		this.servers = servers;
	}

	public Set<ManagedServer> getServers() {
		return servers;
	}

	public Map<NodeAgent, List<String>> getServerNamesPerNode() {
		Map<NodeAgent, List<String>> serverNamesPerNode = new HashMap<NodeAgent, List<String>>();
		if(servers != null) {
			for (ManagedServer server : servers) {
				NodeAgent node = server.getNode();
				List<String> serverNames = serverNamesPerNode.get(node);
				if (serverNames == null) {
					serverNames = new ArrayList<String>();
					serverNamesPerNode.put(node, serverNames);
				}
				serverNames.add(server.getName());
			}
		}
		return serverNamesPerNode;
	}

	public Set<Node> getNodes() {
		Set<Node> nodes = new HashSet<Node>();
		if(servers != null) {
			for (ManagedServer server : servers) {
				nodes.add(server.getNode());
			}
		}
		return nodes;
	}

	@Override
    public String getContainmentPath() {
	    return "/ServerCluster:" + getName();
    }

	@Override
	public String getWasConfigIdType() {
		return "ServerCluster";
	}

	@Override
	public String getWasTargetType() {
		return "cluster";
	}

	@Override
	public String getShortTypeDescription() {
		return "cluster";
	}

	public List<String> getApplicationManagerObjectNames() {
		Map<NodeAgent, List<String>> serverNamesPerNode = getServerNamesPerNode();
		ArrayList<String> applicationManagerObjectNames = new ArrayList<String>();
		for (Map.Entry<NodeAgent, List<String>> each : serverNamesPerNode.entrySet()) {
			NodeAgent eachNode = each.getKey();
			List<String> eachNodeServerNames = each.getValue();
			for (String eachServerName : eachNodeServerNames) {
				applicationManagerObjectNames.add("cell=" + cell.getCellName() + ",node=" + eachNode.getName() + ",type=ApplicationManager,process=" + eachServerName + ",*");
			}
		}
		return applicationManagerObjectNames;
	}

	@Inspect
	public void inspect(InspectionPlanningContext ctx) {
		Map<String, Object> pythonVars = newHashMap();
		pythonVars.put("container", this);
		ctx.addStep(new PythonInspectionStep(this, this.getManagingContainer(), "was/container/inspect-cluster.py", pythonVars, "Inspect " + this));
	}

}
