/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.overthere.OverthereConnection;

public class CheckWasInstallationStep
implements InspectionStep {
    private Cell cell;
    private boolean validInstallation;

    public CheckWasInstallationStep(Cell cell) {
        this.cell = cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(InspectionExecutionContext ctx) throws Exception {
        OverthereConnection c = this.cell.getHost().getConnection();
        try {
            this.validInstallation = true;
            this.checkDirectoryExistence(ctx, c, this.cell.getWasHome());
            this.checkDirectoryExistence(ctx, c, this.cell.getConfigDirPath());
            this.checkFileExistenceAndExecutability(ctx, c, this.cell.getVersionInfoPath());
            this.checkFileExistenceAndExecutability(ctx, c, this.cell.getWsadminPath());
            Step.Result result = this.validInstallation ? Step.Result.Success : Step.Result.Fail;
            return result;
        }
        finally {
            c.close();
        }
    }

    protected void checkDirectoryExistence(InspectionExecutionContext ctx, OverthereConnection c, String dirPath) {
        ctx.logOutput("Checking whether directory " + dirPath + " exists on " + this.cell.getHost());
        if (!c.getFile(dirPath).exists()) {
            ctx.logError("Directory " + dirPath + " does not exist on " + this.cell.getHost());
            this.validInstallation = false;
        }
    }

    private void checkFileExistenceAndExecutability(InspectionExecutionContext ctx, OverthereConnection c, String filePath) {
        ctx.logOutput("Checking whether file " + filePath + " exists on " + this.cell.getHost() + " exists and is executable");
        if (!c.getFile(filePath).exists()) {
            ctx.logError("File " + filePath + " does not exist on " + this.cell.getHost());
            this.validInstallation = false;
        } else if (!c.getFile(filePath).canExecute()) {
            ctx.logError("File " + filePath + " on " + this.cell.getHost() + " is not executable");
            this.validInstallation = false;
        }
    }

    public String getDescription() {
        return "Checking whether " + this.cell + " is a valid WebSphere Application Server installation";
    }
}

