/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.was.container.BaseCell;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.WasVersion;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.util.CapturingOverthereProcessOutputHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GetWasVersionStep
implements InspectionStep {
    private Cell cell;

    public GetWasVersionStep(Cell cell) {
        this.cell = cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(InspectionExecutionContext ctx) throws Exception {
        OverthereConnection adminConnection = this.cell.getHost().getConnection();
        try {
            CapturingOverthereProcessOutputHandler capturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
            int res = adminConnection.execute((OverthereProcessOutputHandler)capturedOutput, CmdLine.build((String[])new String[]{this.cell.getVersionInfoPath()}));
            if (res != 0) {
                ctx.logError("Non-zero exitcode from " + this.cell.getVersionInfoPath() + ": " + res);
                Step.Result result = Step.Result.Fail;
                return result;
            }
            for (String eachLine : capturedOutput.getOutputLines()) {
                String[] matches;
                if (!eachLine.startsWith("Version") || (matches = GetWasVersionStep.regexMatch(eachLine, "Version\\s+(\\d+)\\.(\\d+)\\.[\\d\\.]*")) == null || matches.length != 2) continue;
                int majorVersion = Integer.parseInt(matches[0]);
                int minorVersion = Integer.parseInt(matches[1]);
                if (majorVersion == 6 && minorVersion == 1) {
                    ((BaseCell)this.cell).setVersion(WasVersion.WAS_61);
                } else if (majorVersion == 7 && minorVersion == 0) {
                    ((BaseCell)this.cell).setVersion(WasVersion.WAS_70);
                } else if (majorVersion == 8 && minorVersion == 0) {
                    ((BaseCell)this.cell).setVersion(WasVersion.WAS_80);
                } else {
                    ctx.logError("Cannot set version on " + this.cell + ": version " + majorVersion + "." + minorVersion + " is not supported");
                    Step.Result result = Step.Result.Fail;
                    return result;
                }
                Step.Result result = Step.Result.Success;
                return result;
            }
            ctx.logError("Could not determine installed version of " + this.cell);
            Step.Result result = Step.Result.Fail;
            return result;
        }
        finally {
            adminConnection.close();
        }
    }

    public String getDescription() {
        return "Get version of " + this.cell;
    }

    private static String[] regexMatch(String str, String regexPattern) {
        Matcher m = Pattern.compile(regexPattern).matcher(str);
        if (m.matches()) {
            String[] matches = new String[m.groupCount()];
            for (int i = 0; i < matches.length; ++i) {
                matches[i] = m.group(i + 1);
            }
            return matches;
        }
        return null;
    }
}

