import types
import sys

def toAdminConfigArgs(properties):
    args = []
    for propName, propValue in properties.items():
        if propValue != None:
            if isinstance(propValue, DictionaryObject):
                args.append([propName, str(propValue.name)])
            else:
                args.append([propName, str(propValue)])
    return args

def toAdminTaskArgs(properties):
    args = []
    for propName, propValue in properties.items():
        if propValue != None:
            if isinstance(propValue, DictionaryObject):
                args.extend(["-" + propName, str(propValue.name)])
            else:
                args.extend(["-" + propName, str(propValue)])
    return args

def validateNotEmpty(val, error):
    if val is None or val == "":
        print error
        sys.exit(1)
    return val

# Functions invoked by the PythonScriptStep

def saveConfiguration():
    if AdminConfig.hasChanges():
        print "Saving configuration"
        AdminConfig.save()

def connectFromDaemon():
    pass

def connectFromStandAloneScript():
    pass

def disconnectFromDaemon():
    pass

def disconnectFromStandAloneScript():
    saveConfiguration()

def runScriptFromDaemon(scriptPath):
    execfile(scriptPath)
    saveConfiguration()

def disconnectFromDaemonForError():
    if AdminConfig.hasChanges():
        print "Discarding unsaved changes"
        AdminConfig.reset()

def isApplicationRunningOnServer(applicationName, serverName, nodeName) :
    return AdminControl.completeObjectName("type=Application,name=%s,process=%s,node=%s,*" % (applicationName, serverName, nodeName)) != ""

