/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WasVersionInfoParser {
    public int majorVersion = -1;
    public int minorVersion = -1;

    public WasVersionInfoParser parse(List<String> list) {
        boolean bl = false;
        for (String string : list) {
            String[] stringArray;
            if (string.startsWith("Name")) {
                stringArray = WasVersionInfoParser.regexMatch(string, "Name\\s+(\\w.+)");
                if (stringArray != null && stringArray.length == 1 && stringArray[0].startsWith("IBM WebSphere Application Server")) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            if (!bl || !string.startsWith("Version") || (stringArray = WasVersionInfoParser.regexMatch(string, "Version\\s+(\\d+)\\.(\\d+)\\.[\\d\\.]*")) == null || stringArray.length != 2) continue;
            this.majorVersion = Integer.parseInt(stringArray[0]);
            this.minorVersion = Integer.parseInt(stringArray[1]);
            return this;
        }
        return this;
    }

    public WasVersionInfoParser parse(String[] stringArray) {
        return this.parse(Arrays.asList(stringArray));
    }

    public boolean isSuccess() {
        return this.majorVersion != -1 && this.minorVersion != -1;
    }

    private static String[] regexMatch(String string, String string2) {
        Matcher matcher = Pattern.compile(string2).matcher(string);
        if (matcher.matches()) {
            String[] stringArray = new String[matcher.groupCount()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = matcher.group(i + 1);
            }
            return stringArray;
        }
        return null;
    }
}

