/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.was.container.BaseCell;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.WasVersion;
import com.xebialabs.deployit.plugin.was.util.WasVersionInfoParser;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.util.CapturingOverthereProcessOutputHandler;

public class GetWasVersionStep
implements Step {
    private Cell cell;

    public GetWasVersionStep(Cell cell) {
        this.cell = cell;
    }

    public int getOrder() {
        return 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        OverthereConnection adminConnection = this.cell.getHost().getConnection();
        try {
            CapturingOverthereProcessOutputHandler capturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
            int res = adminConnection.execute((OverthereProcessOutputHandler)capturedOutput, CmdLine.build((String[])new String[]{this.cell.getVersionInfoPath()}));
            if (res != 0) {
                ctx.logError("Non-zero exitcode from " + this.cell.getVersionInfoPath() + ": " + res);
                StepExitCode stepExitCode = StepExitCode.FAIL;
                return stepExitCode;
            }
            StepExitCode stepExitCode = this.checkWasVersion(ctx, capturedOutput);
            return stepExitCode;
        }
        finally {
            adminConnection.close();
        }
    }

    private StepExitCode checkWasVersion(ExecutionContext ctx, CapturingOverthereProcessOutputHandler capturedOutput) {
        WasVersionInfoParser wasVersionInfoParser = new WasVersionInfoParser().parse(capturedOutput.getOutputLines());
        if (wasVersionInfoParser.isSuccess()) {
            if (wasVersionInfoParser.majorVersion == 6 && wasVersionInfoParser.minorVersion == 1) {
                ((BaseCell)this.cell).setVersion(WasVersion.WAS_61);
            } else if (wasVersionInfoParser.majorVersion == 7 && wasVersionInfoParser.minorVersion == 0) {
                ((BaseCell)this.cell).setVersion(WasVersion.WAS_70);
            } else if (wasVersionInfoParser.majorVersion == 8 && wasVersionInfoParser.minorVersion == 0) {
                ((BaseCell)this.cell).setVersion(WasVersion.WAS_80);
            } else {
                ctx.logError("Cannot set version on " + this.cell + ": version " + wasVersionInfoParser.majorVersion + "." + wasVersionInfoParser.minorVersion + " is not supported");
                return StepExitCode.FAIL;
            }
            return StepExitCode.SUCCESS;
        }
        ctx.logError("Could not determine installed version of " + this.cell);
        return StepExitCode.FAIL;
    }

    public String getDescription() {
        return "Get version of " + this.cell;
    }
}

