/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.DeploymentManager;
import com.xebialabs.deployit.plugin.was.container.ManagedServer;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import com.xebialabs.deployit.plugin.was.container.WasAppContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="A WebSphere cluster managed by a deployment manager (WAS ND)")
public class Cluster
extends BaseContainer
implements WasAppContainer {
    @Property(asContainment=true, label="Deployment manager that manages this this cluster")
    private DeploymentManager cell;
    @Property(required=false, label="Cluster members", description="Servers that are part of this cluster")
    private Set<ManagedServer> servers;

    @Override
    public DeploymentManager getCell() {
        return this.cell;
    }

    public PythonManagingContainer getManagingContainer() {
        return this.getCell();
    }

    @Override
    public String getCellName() {
        Preconditions.checkNotNull((Object)this.getCell(), (String)"%s has null cell", (Object[])new Object[]{this});
        return this.getCell().getName();
    }

    public Host getHost() {
        return this.getCell().getHost();
    }

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        return ControlTaskDelegate.dispatch((String)name, args, (ConfigurationItem)this, (Container)this);
    }

    public void setCell(DeploymentManager cell) {
        this.cell = cell;
    }

    public void setServers(Set<ManagedServer> servers) {
        this.servers = servers;
    }

    public Set<ManagedServer> getServers() {
        return this.servers;
    }

    public Map<NodeAgent, List<String>> getServerNamesPerNode() {
        HashMap<NodeAgent, List<String>> serverNamesPerNode = new HashMap<NodeAgent, List<String>>();
        if (this.servers != null) {
            for (ManagedServer server : this.servers) {
                NodeAgent node = server.getNode();
                Preconditions.checkNotNull((Object)node, (String)"%s has null node", (Object[])new Object[]{server});
                ArrayList<String> serverNames = (ArrayList<String>)serverNamesPerNode.get(node);
                if (serverNames == null) {
                    serverNames = new ArrayList<String>();
                    serverNamesPerNode.put(node, serverNames);
                }
                serverNames.add(server.getName());
            }
        }
        return serverNamesPerNode;
    }

    public Set<Node> getNodes() {
        HashSet<Node> nodes = new HashSet<Node>();
        if (this.servers != null) {
            for (ManagedServer server : this.servers) {
                nodes.add(server.getNode());
            }
        }
        return nodes;
    }

    @Override
    public String getContainmentPath() {
        return "/ServerCluster:" + this.getName();
    }

    @Override
    public String getWasConfigIdType() {
        return "ServerCluster";
    }

    @Override
    public String getWasTargetType() {
        return "cluster";
    }

    @Override
    public String getShortTypeDescription() {
        return "cluster";
    }

    @Override
    public List<String> getApplicationManagerObjectNames() {
        Map<NodeAgent, List<String>> serverNamesPerNode = this.getServerNamesPerNode();
        ArrayList<String> applicationManagerObjectNames = new ArrayList<String>();
        for (Map.Entry<NodeAgent, List<String>> each : serverNamesPerNode.entrySet()) {
            NodeAgent eachNode = each.getKey();
            List<String> eachNodeServerNames = each.getValue();
            for (String eachServerName : eachNodeServerNames) {
                applicationManagerObjectNames.add("cell=" + this.getCellName() + ",node=" + eachNode.getName() + ",type=ApplicationManager,process=" + eachServerName + ",*");
            }
        }
        return applicationManagerObjectNames;
    }
}

