/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.contributor;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.WasContainer;
import com.xebialabs.deployit.plugin.was.util.ContainerRestartStrategy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StopStartContainer {
    private static final String STOP_SCRIPT_PROPERTY = "stopScript";
    private static final String START_SCRIPT_PROPERTY = "startScript";
    private static final String RESTART_SCRIPT_PROPERTY = "restartScript";
    private static final String STOP_ORDER_PROPERTY = "stopOrder";
    private static final String START_ORDER_PROPERTY = "startOrder";
    private static final String RESTART_ORDER_PROPERTY = "restartOrder";
    public static final String CONTAINER_RESTART_STRATEGY = "containerRestartStrategy";

    @Contributor
    public void stopAndStartContainers(Deltas deltas, DeploymentPlanningContext ctx) {
        HashSet stopStartContainers = Sets.newHashSet();
        HashSet restartStartContainers = Sets.newHashSet();
        this.findContainers(deltas, stopStartContainers, restartStartContainers);
        for (WasContainer wasContainer : stopStartContainers) {
            this.addStep(STOP_SCRIPT_PROPERTY, STOP_ORDER_PROPERTY, "Stop", wasContainer, ctx);
            this.addStep(START_SCRIPT_PROPERTY, START_ORDER_PROPERTY, "Start", wasContainer, ctx);
        }
        for (WasContainer wasContainer : restartStartContainers) {
            if (this.hasRestartScript(wasContainer)) {
                this.addStep(RESTART_SCRIPT_PROPERTY, RESTART_ORDER_PROPERTY, "Restart", wasContainer, ctx);
                continue;
            }
            this.addStep(STOP_SCRIPT_PROPERTY, RESTART_ORDER_PROPERTY, "Stop", wasContainer, ctx);
            this.addStep(START_SCRIPT_PROPERTY, RESTART_ORDER_PROPERTY, "Start", wasContainer, ctx);
        }
    }

    private void addStep(String scriptProperty, String orderProperty, String verb, WasContainer container, DeploymentPlanningContext ctx) {
        if (container.hasProperty(scriptProperty) && container.hasProperty(orderProperty)) {
            ctx.addStep((Step)new PythonDeploymentStep(((Integer)container.getProperty(orderProperty)).intValue(), (PythonManagingContainer)container.getCell(), (String)container.getProperty(scriptProperty), (Map)ImmutableMap.of((Object)"container", (Object)container), String.format("%s '%s'", verb, container.getName())));
        }
    }

    private boolean hasRestartScript(WasContainer container) {
        return container.hasProperty(RESTART_SCRIPT_PROPERTY) && !Strings.isNullOrEmpty((String)((String)container.getProperty(RESTART_SCRIPT_PROPERTY)));
    }

    private void findContainers(Deltas deltas, Set<WasContainer> stopStartContainers, Set<WasContainer> restartStartContainers) {
        for (Delta delta : deltas.getDeltas()) {
            Deployed deployed = delta.getOperation() == Operation.DESTROY ? delta.getPrevious() : delta.getDeployed();
            if (!(deployed.getContainer() instanceof WasContainer) || !deployed.hasProperty(CONTAINER_RESTART_STRATEGY)) continue;
            if (deployed.getProperty(CONTAINER_RESTART_STRATEGY) == ContainerRestartStrategy.STOP_START) {
                stopStartContainers.add((WasContainer)deployed.getContainer());
                continue;
            }
            if (deployed.getProperty(CONTAINER_RESTART_STRATEGY) != ContainerRestartStrategy.RESTART) continue;
            restartStartContainers.add((WasContainer)deployed.getContainer());
        }
        restartStartContainers.removeAll(stopStartContainers);
    }
}

