def additionalInspection(deployedId,appName, deploymentObjectId, container):
    vhId = getVirtualHostIdForApp(appName)
    if vhId:
        inspectedProperty(deployedId, "virtualHost",vhId)
    inspectedProperty(deployedId, "contextRoot",getContextRoot(appName))
    webServers = resolveWebServers(appName)
    if len(webServers) > 0:
        inspectedProperty(deployedId, "webServers", webServers)

def canHandleOnlyWar(type):
    return type == "war"

for c in findAllContainers(container, onlyWasAppContainer=True):
    discoverAndInspectAppModules(c, canHandleOnlyWar, additionalInspection)
