def wmqConnectionFactoryProps(deployed):
    exposedProperties = deployed.getExposedProperties(True)

    if getVersion(deployed.container) == 'WAS_61':
        if deployed.transportType == 'BINDINGS_THEN_CLIENT':
            print "BINDINGS_THEN_CLIENT default mapped to BINDINGS on WAS 6.1"
            exposedProperties['transportType'] = 'BINDINGS'

    if not exposedProperties.get('sslConfiguration'):
        exposedProperties['sslConfiguration'] = exposedProperties['sslConfigurationName']
        del exposedProperties['sslConfigurationName']

    return exposedProperties

def inspectWmqConnectionFactories(deployedId, jmsName, jmsId, container, prototype):
    inspectJmsQueueConnectionFactories(deployedId, jmsName, jmsId, container, prototype)

    if 'sslConfiguration' in getConfigTypeAttrs(prototype.wasType):
        inspectedProperty(deployedId, 'sslConfigurationName', AdminConfig.showAttribute(jmsId, 'sslConfiguration'))