/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.contributor;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.was.container.Cluster;
import com.xebialabs.deployit.plugin.was.container.WasContainer;
import com.xebialabs.deployit.plugin.was.contributor.StopStartContainer;
import com.xebialabs.deployit.plugin.was.util.ContainerRestartStrategy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class StopStartCoreGroupContributor
extends StopStartContainer {
    @Contributor
    public void stopAndStartCoreGroupServers(Deltas deltas, DeploymentPlanningContext ctx) {
        this.doStopAndStartContainers(deltas, ctx);
    }

    @Override
    protected void findContainers(Deltas deltas, Set<WasContainer> stopStartContainers, Set<WasContainer> restartStartContainers) {
        for (Delta delta : deltas.getDeltas()) {
            Set<WasContainer> previousContainers = this.findReferencedCoreGroupServers(delta.getPrevious());
            Set<WasContainer> currentContainers = this.findReferencedCoreGroupServers(delta.getDeployed());
            stopStartContainers.addAll((Collection<WasContainer>)Sets.symmetricDifference(previousContainers, currentContainers));
        }
    }

    private Set<WasContainer> findReferencedCoreGroupServers(Deployed<?, ?> deployed) {
        Collection coreGroupClusters;
        HashSet containers = Sets.newHashSet();
        if (!this.isApplicable(deployed)) {
            return containers;
        }
        Collection coreGroupServers = (Collection)deployed.getProperty("coreGroupServers");
        if (coreGroupServers != null) {
            containers.addAll(coreGroupServers);
        }
        if ((coreGroupClusters = (Collection)deployed.getProperty("coreGroupClusters")) != null) {
            for (Cluster coreGroupCluster : coreGroupClusters) {
                containers.addAll(coreGroupCluster.getServers());
            }
        }
        return containers;
    }

    private boolean isApplicable(Deployed<?, ?> deployed) {
        return deployed != null && deployed.getType().instanceOf(Type.valueOf((String)"was.CoreGroup")) && deployed.hasProperty("containerRestartStrategy") && deployed.getProperty("containerRestartStrategy") != ContainerRestartStrategy.NONE;
    }
}

