package com.xebialabs.deployit.plugin.was.step;

import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.RulePostConstruct;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.rules.StepPostConstructContext;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.steps.CalculatedStep;
import com.xebialabs.deployit.plugin.steps.ContextHelper;
import com.xebialabs.deployit.plugin.steps.TargetContainerJavaHelper;
import com.xebialabs.deployit.plugin.was.container.Cell;

@StepMetadata(name = "wsadmin")
public class WsadminStep extends CalculatedStep implements PreviewStep {

    @StepParameter(description = "WAS cell where to execute the python script", calculated = true)
    private Cell targetCell;

    @StepParameter(description = "Path to the python script to be executed")
    private String script;

    @StepParameter(description = "Dictionary that represent context available to the python script", required = false, calculated = true)
    private Map<String, Object> pythonContext = new HashMap<>();

    @StepParameter(description = "If true, the artifacts from the python context will be uploaded to the target host and available to the script as bindingName.file. Defaults to true.")
    private Boolean uploadArtifactsInPythonContext = true;

    private PythonDeploymentStep pythonStep;

    @RulePostConstruct
    @Override
    public void doPostConstruct(StepPostConstructContext ctx) {
        super.doPostConstruct(ctx);
        pythonStep = new PythonDeploymentStep(getOrder(), calculateTargetCell(ctx), script, ContextHelper.defaultContext(ctx, pythonContext), getDescription());
        pythonStep.setUploadArtifactData(uploadArtifactsInPythonContext);
    }

    private Cell calculateTargetCell(final StepPostConstructContext ctx) {
        if (targetCell == null) {
            final PythonManagedContainer targetContainer = TargetContainerJavaHelper.defaultTargetContainer(ctx, PythonManagedContainer.class);
            if (targetContainer != null && targetContainer.getManagingContainer() instanceof Cell)
                targetCell = (Cell) targetContainer.getManagingContainer();
        }
        return targetCell;
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        return pythonStep.execute(ctx);
    }

    @Override
    public Preview getPreview() {
        return pythonStep.getPreview();
    }
}
