import sys
from types import *

def createCluster(container):
    args = ['-clusterConfig']
    clusterConfigArgs = ['-clusterName', container.name]
#     if container.serverType == 'PROXY_SERVER':
    print "cluster type: %s" % container.serverType
    clusterConfigArgs.extend(['-clusterType', container.serverType])
    args.append(clusterConfigArgs)
    print "Creating cluster '%s' with arguments: %s" % (container.name, listToAdminTaskArgs(args))
    AdminTask.createCluster(listToAdminTaskArgs(args))

def createMembers(container, template):
    firstMember = True
    for server in container.servers:
      serverArgs = ['-clusterName', container.name, '-memberConfig', ['-memberNode', server.nodeName, '-memberName', server.name, '-memberWeight', str(server.weight)]]
      if template is not None and template != '':
        if firstMember:
          serverArgs.append('-firstMember')
          serverArgs.append(['-templateName', template])
          firstMember = False
        else:
          print "WARN: Ignoring template '%s' since '%s' is not the first member of the cluster" % (template, server.name)
      print "Creating member server '%s' in cluster '%s' with arguments: %s" % (server.name, container.name, listToAdminTaskArgs(serverArgs))
      AdminTask.createClusterMember(listToAdminTaskArgs(serverArgs))

def syncServers(cluster):
    nodeNames = {}
    for server in cluster.servers:
        nodeNames[server.nodeName] = server.nodeName

    for nodeName in nodeNames.keys():
        syncNode(nodeName, full='true')

def checkIfClusterExists(container):
    cluster = AdminConfig.getid('/ServerCluster:%s/' % (container.name))
    if cluster != "":
        print "WARN: Cluster '%s' already exists. Doing nothing." % (container.name)
        sys.exit(0)

was_version = getVersion(container)
template = parameters.template

checkIfClusterExists(container)
createCluster(container)
createMembers(container, template)

saveConfiguration()

syncServers(container)

