containerId = validateNotEmpty(AdminConfig.getid(deployed.container.containmentPath), "Cannot locate container at path %s" %(deployed.container.containmentPath))
serverName  = deployed.container.name
nodeName = deployed.container.nodeName
cellName = deployed.container.cellName
nodeId = AdminConfig.getid('/Cell:%s/Node:%s/'%(cellName, nodeName))
serverEntries = validateNotEmpty(wsadminToList(AdminConfig.list( 'ServerEntry', nodeId)), "Cannot locate ServerEntries on node %s" % (nodeName))
serverEntryList = [serverEntry for serverEntry in serverEntries if AdminConfig.showAttribute(serverEntry, 'serverName') == serverName]
if not serverEntryList:
    raise "Cannot locate serverName with name %s" % serverName
for serverEntry in serverEntryList:
    namedEndPoints = validateNotEmpty(wsadminToList(AdminConfig.list( "NamedEndPoint" , serverEntry)), "Cannot locate NamedEndPoints in %s" %(serverEntry))
    namedEndPointList = [namedEndPoint for namedEndPoint in namedEndPoints if AdminConfig.showAttribute(namedEndPoint, 'endPointName') == deployed.name]

    exposedProperties = deployed.getExposedProperties(True)
    args = toAdminConfigArgs(exposedProperties)
    if not namedEndPointList:
        print ("WARNING: Cannot locate endPointName with name %s. Will create custom NamedEndpoint and Server Port with args %s" % (deployed.name, args))
        namedEndpoint = AdminConfig.create('NamedEndPoint', serverEntry, "[[endPointName '%s']]" % deployed.name)
        endpoint = AdminConfig.create('EndPoint', namedEndpoint, args)
    else:
        endPoint = AdminConfig.showAttribute(namedEndPointList[0], "endPoint" )
        print 'Modify Server Port %s of %s with args %s' % (deployed.name, endPoint, args)
        AdminConfig.modify(endPoint, args)
