/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.deployed;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.was.container.WasContainer;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployed;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedHelper;
import com.xebialabs.overthere.OverthereFile;
import java.util.Map;

@Metadata(virtual=true, description="Base class for all extensible deployed artifact configuration items.")
@Placeholders
public class ExtensibleDeployedArtifact
extends ExtensibleDeployed<DeployableArtifact>
implements DerivedArtifact<DeployableArtifact> {
    private OverthereFile derivedFile;
    @Property(hidden=true, defaultValue="Rollout", description="The word that is used to prefix a step description for the rollout operation.")
    private String rolloutEditionedVerb;
    @Property(hidden=true, defaultValue="20", description="The order in which a rollout step will be executed.")
    private int rolloutEditionedOrder;
    @Property(hidden=true, required=false, description="Python script invoked to rollout a Java EE artifact.")
    private String rolloutEditionedScript;
    @Property(hidden=true, defaultValue="10", description="The order in which a create step for Editioned application will be executed(was85nd only).")
    private int createEditionedOrder;
    @Property(description="A Map containing all the placeholders mapped to their values. Special values are <ignore> or <empty>", required=false)
    private Map<String, String> placeholders = Maps.newHashMap();

    public OverthereFile getFile() {
        return this.derivedFile;
    }

    public void setFile(OverthereFile file) {
        this.derivedFile = file;
    }

    public DeployableArtifact getSourceArtifact() {
        return (DeployableArtifact)this.getDeployable();
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void createEditioned(DeploymentPlanningContext ctx, Delta delta, PythonManagedDeployed.CheckpointInfo checkpoint) {
        this.addStep(ctx, this.createEditionedOrder, this.getCreateScript(), this.getCreateVerb(), checkpoint);
        this.addStep(ctx, this.rolloutEditionedOrder, this.rolloutEditionedScript, this.rolloutEditionedVerb, checkpoint);
    }

    @Override
    public void modify(DeploymentPlanningContext ctx, Delta delta, PythonManagedDeployed.CheckpointInfo checkpoint) {
        if (this.addStep(ctx, this.getModifyOrder(), this.getModifyScript(), this.getModifyVerb(), checkpoint)) {
            this.addStartStep(ctx);
            this.addStopStep(ctx);
            ExtensibleDeployedHelper.syncNodes(ctx, this.getSyncAfterModifyOrder(), (WasContainer)this.getContainer());
        } else {
            ExtensibleDeployedArtifact previous = (ExtensibleDeployedArtifact)delta.getPrevious();
            ExtensibleDeployedArtifact current = (ExtensibleDeployedArtifact)delta.getDeployed();
            previous.setRestartStrategy(current.getRestartStrategy());
            previous.setContainerRestartStrategy(current.getContainerRestartStrategy());
            if (((Boolean)current.getProperty("isEdition")).booleanValue()) {
                current.createEditioned(ctx, delta, checkpoint);
                previous.destroy(ctx, delta, checkpoint, false);
            } else if (checkpoint == null) {
                previous.destroy(ctx, delta, null, true);
                current.create(ctx, delta, null);
            } else {
                previous.destroy(ctx, delta);
                current.create(ctx, delta);
            }
        }
    }
}

