import copy

def setClientAuthentication(deployed):
    if deployed.clientAuthentication == 'NONE':
        authentication = [['clientAuthentication', 'false'], ['clientAuthenticationSupported', 'false']]
    elif deployed.clientAuthentication == 'REQUIRED':
        authentication = [['clientAuthentication', 'true']]
    elif deployed.clientAuthentication == 'SUPPORTED':
        authentication = [['clientAuthentication', 'false'], ['clientAuthenticationSupported', 'true']]
    return authentication

def getConfigurationItemData(deployedName, deployed, objectType, nameAttribute):
    sslConfigList = wsadminToList(AdminConfig.list(objectType))
    if not deployedName:
        defaultScopeList = [alias for alias in sslConfigList if AdminConfig.showAttribute(alias, 'scopeType') == (deployed.container.wasTargetType).lower()]
        if defaultScopeList:
            deployedName = AdminConfig.showAttribute(defaultScopeList[0], nameAttribute)
    configAliasList = [alias for alias in sslConfigList if AdminConfig.showAttribute(alias, nameAttribute) == deployedName]
    if configAliasList:
        return configAliasList[0]
    return None

def sslConfigArgs(deployed):
    exposedProperties = deployed.getExposedProperties(True)
    del exposedProperties['name']
    exposedProperties['keyStore'] = validateNotEmpty(getConfigurationItemData(deployed.keyStore, deployed, 'KeyStore', 'name'), "Cannot locate keyStore '%s' in container '%s'" % (deployed.keyStore, deployed.container.name))
    exposedProperties['trustStore'] = validateNotEmpty(getConfigurationItemData(deployed.trustStore, deployed, 'KeyStore', 'name'), "Cannot locate trustStore '%s' in container '%s'" % (deployed.trustStore, deployed.container.name))
    settingArgs = toAdminConfigArgs(exposedProperties)
    settingArgs.extend(setClientAuthentication(deployed))
    if deployed.securityLevel == 'CUSTOM' and deployed.enabledCiphers:
        cipherString = ""
        for ciphers in deployed.enabledCiphers:
            cipherString = cipherString + ' ' +'%s' % ciphers
        settingArgs.extend([['enabledCiphers', cipherString]])
    return [['alias', deployed.name], ['type', "JSSE"], ['setting', settingArgs], ['managementScope', validateNotEmpty(getConfigurationItemData(deployed.managementScope, deployed, 'ManagementScope', 'scopeName'), "Cannot locate managementScope '%s' in container '%s'" % (deployed.managementScope, deployed.container.name))]]

def inspectNestedProperties(deployedId, deployedName, parentId, nestedProperty):
    nestedPropId = AdminConfig.showAttribute(parentId, nestedProperty)
    if nestedProperty == "managementScope":
        inspectedProperty(deployedId, 'managementScope', AdminConfig.showAttribute(nestedPropId, 'scopeName'))
    else:
        inspectDeployedProperties(deployedId, deployedName, nestedPropId, prototype)
        inspectenableCiphers(deployedId, nestedPropId, 'enabledCiphers')

def getValueOfConfigRoot(cellName):
    varSubEntries = wsadminToList(AdminConfig.list('VariableSubstitutionEntry'))
    allVarSubEntries = [entry for entry in varSubEntries if AdminConfig.showAttribute(entry, "symbolicName") == 'USER_INSTALL_ROOT']
    if allVarSubEntries:
        varVal = AdminConfig.showAttribute(allVarSubEntries[0], "value")
        return varVal + '/config'

def keystoreArgs(deployed):
    fullPath = deployed.location
    if deployed.useRelativePath:
        configRoot = getValueOfConfigRoot(deployed.container.cellName)
        print "Derived config root: '%s'" % configRoot
        if fullPath.find(configRoot) == 0:
            fullPath = '${CONFIG_ROOT}' + fullPath[len(configRoot):]
    exposedProperties = deployed.getExposedProperties(True)
    exposedProperties.update({'location':fullPath, 'managementScope':validateNotEmpty(getConfigurationItemData(deployed.managementScope, deployed, 'ManagementScope', 'scopeName'), "Cannot locate managementScope '%s' in container '%s'" % (deployed.managementScope, deployed.container.name)), 'type':deployed.keyStoreType})
    if getVersion(deployed.container) != 'WAS_61':
        exposedProperties['description'] = deployed.description
    return toAdminConfigArgs(exposedProperties)

def modifyConfigurationItem(deployed, objectType, deployedName, objectId, args):
    print "Modifying '%s' '%s' in container '%s' with args '%s'" % (objectType, deployedName, deployed.container.name, mask_password_value(args, 'password'))
    adminConfigModify(objectId, args)

def destroyConfigurationItem(deployed, objectType, deployedName, objectId):
    if objectId:
        print "Destroying '%s' data '%s' in container '%s'" % (objectType, deployedName, deployed.container.name)
        AdminConfig.remove(objectId)
    else:
        print "No SSL Config data '%s' found in container '%s'. Nothing to do" % (deployedName, deployed.container.name)

# Utility method added for masking the password values of deployed arguments
def mask_password_value(prop_args, *property_name):
    prop_args_copy = copy.deepcopy(prop_args)
    for property in prop_args_copy:
        if property[0] in property_name:
            property[1] = "******"
    return prop_args_copy